/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPsiUtil {
    @Nullable
    public static JSType getTypeFromDeclaration(JSNamedElement element) {
        ASTNode typeExpr = JSPsiImplUtils.getTypeExpressionFromDeclaration(element);
        if (typeExpr != null) {
            PsiElement typeExprPsi = typeExpr.getPsi();
            return typeExprPsi instanceof TypeScriptType ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptType)typeExprPsi)) : JSAnyType.get(typeExprPsi, true);
        }
        return null;
    }

    @Nullable
    public static JSClass getParentClass(@Nullable PsiElement element) {
        PsiElement secondParent;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSClass) {
            return (JSClass)parent;
        }
        if (parent instanceof TypeScriptObjectType && (secondParent = parent.getParent()) instanceof JSClass) {
            return (JSClass)secondParent;
        }
        return null;
    }

    public static boolean isAmbientDeclaration(@Nullable PsiElement element) {
        if (element instanceof JSAttributeListOwner) {
            while (element != null && !(element instanceof JSFile)) {
                if (TypeScriptPsiUtil.hasAmbientAttribute((JSAttributeListOwner)element)) {
                    return true;
                }
                element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, TypeScriptModule.class, JSFile.class});
            }
        }
        return false;
    }

    public static boolean hasAmbientAttribute(@NotNull JSAttributeListOwner element) {
        boolean result;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "hasAmbientAttribute"));
        }
        JSAttributeList list = element.getAttributeList();
        boolean bl = result = list != null && list.hasModifier(JSAttributeList.ModifierType.DECLARE);
        return result;
    }

    public static boolean isNamedTypeDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement;
    }

    public static boolean isNamedTypeContainerDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptModule || element instanceof TypeScriptImportStatement;
    }

    @Nullable
    public static TypeScriptExportAssignment findExportAssignment(@NotNull PsiElement module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "findExportAssignment"));
        }
        TypeScriptExportAssignment exportAssignment = null;
        if (module instanceof PsiFileImpl) {
            StubElement stub = ((PsiFileImpl)module).getStub();
            if (stub != null) {
                StubElement exportAssignmentStub = stub.findChildStubByType(TypeScriptElementTypes.EXPORT_ASSIGNMENT);
                if (exportAssignmentStub != null) {
                    exportAssignment = (TypeScriptExportAssignment)exportAssignmentStub.getPsi();
                }
            } else {
                exportAssignment = (TypeScriptExportAssignment)((PsiFileImpl)module).findChildByClass(TypeScriptExportAssignment.class);
            }
        } else if (module instanceof TypeScriptModuleImpl) {
            exportAssignment = (TypeScriptExportAssignment)((TypeScriptModuleImpl)module).getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.EXPORT_ASSIGNMENT);
        }
        return exportAssignment;
    }

    public static boolean isClassMember(JSParameter parameter) {
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList = parameter.getAttributeList();
        return attributeList != null && JSAttributeList.TYPESCRIPT_ACCESS_TYPE_LIST.contains(accessType = attributeList.getExplicitAccessType());
    }

    @Nullable
    public static String getNameFromIdentifier(@Nullable ASTNode identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            identifier = identifier.getFirstChildNode();
        }
        if (identifier == null) {
            return null;
        }
        if (JSTokenTypes.STRING_LITERALS.contains(identifier.getElementType())) {
            return StringUtil.unquoteString((String)identifier.getText());
        }
        return identifier.getText();
    }

    @Nullable
    public static PsiElement resolveViaImports(@NotNull JSReferenceExpression referenceExpression) {
        Collection elements;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "resolveViaImports"));
        }
        PsiElement resolve = referenceExpression.resolve();
        if (resolve instanceof TypeScriptImportStatement && (elements = ((TypeScriptImportStatement)resolve).findReferencedElements()).size() == 1) {
            resolve = (PsiElement)elements.iterator().next();
        }
        return resolve;
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull JSStubElementImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getStubOrPsiTypeElement"));
        }
        return (TypeScriptType)ArrayUtil.getFirstElement((Object[])TypeScriptPsiUtil.getStubOrPsiTypeElements(element));
    }

    @Nullable
    public static TypeScriptType[] getStubOrPsiTypeElements(@NotNull JSStubElementImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getStubOrPsiTypeElements"));
        }
        return (TypeScriptType[])element.getStubOrPsiChildren(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY);
    }

    public static boolean isTopLevelContainer(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isTopLevelContainer"));
        }
        return element instanceof JSFile || element instanceof TypeScriptModule;
    }

    public static boolean isTopLevelContainerMember(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isTopLevelContainerMember"));
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentOverDefaultAssignable(element);
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    public static boolean isTopLevelContainerMember(@NotNull JSQualifiedObjectStubBase<?> stubElement) {
        if (stubElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElement", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isTopLevelContainerMember"));
        }
        StubElement parentStub = stubElement.getParentStub();
        if (parentStub != null && parentStub.getStubType() == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            parentStub = parentStub.getParentStub();
        }
        if (parentStub != null && parentStub.getStubType() == JSStubElementTypes.VAR_STATEMENT) {
            parentStub = parentStub.getParentStub();
        }
        IStubElementType type = parentStub != null ? parentStub.getStubType() : null;
        return type == JSStubElementTypes.TYPESCRIPT_MODULE || type == null;
    }

    public static PsiElement getParentOverDefaultAssignable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getParentOverDefaultAssignable"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static PsiElement getTopLevelContainer(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "getTopLevelContainer"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    public static boolean isAbstractElement(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "isAbstractElement"));
        }
        JSAttributeList list = element.getAttributeList();
        if (list == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public static JSFunctionItem calculatePossibleFunctionForVariableDefinition(@NotNull JSVariable element, @Nullable PsiElement methodExpression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptPsiUtil", "calculatePossibleFunctionForVariableDefinition"));
        }
        PsiElement parent = methodExpression instanceof JSCallExpression ? methodExpression : (methodExpression == null ? null : methodExpression.getParent());
        boolean hasNew = parent instanceof JSNewExpression;
        PsiElement typeElement = element.getTypeElement();
        if (typeElement instanceof TypeScriptSingleType) {
            TypeScriptSingleType singleType = (TypeScriptSingleType)typeElement;
            String qualifiedTypeName = singleType.getQualifiedTypeName();
            if (qualifiedTypeName == null) {
                return null;
            }
            JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveTypeName(qualifiedTypeName, typeElement);
            if (!result.hasElements()) {
                return null;
            }
            ArrayList allSignatures = ContainerUtil.newArrayList();
            for (PsiElement psiElement : result.getElements()) {
                if (!(psiElement instanceof TypeScriptInterface)) continue;
                allSignatures.addAll(TypeScriptPsiUtil.getCallSignatures((TypeScriptInterface)psiElement, hasNew));
            }
            return allSignatures.size() == 1 ? (JSFunction)ContainerUtil.getFirstItem((Collection)allSignatures) : null;
        }
        return null;
    }

    public static Collection<JSFunction> getCallSignatures(TypeScriptInterface interfaceToProcess, boolean isNew) {
        ArrayList result = ContainerUtil.newArrayList();
        Set<JSClass> parents = TypeScriptUtil.getNonStrictParents((JSClass)interfaceToProcess, true);
        for (JSClass interfaceType : parents) {
            Iterable members = interfaceType.getMembers();
            for (JSElement element : members) {
                TypeScriptCallSignature callSignature;
                if (!(element instanceof TypeScriptCallSignature) || (callSignature = (TypeScriptCallSignature)element).isConstructor() != isNew) continue;
                result.add(callSignature);
            }
        }
        return result;
    }
}

