/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptEntityNameImpl
extends JSElementImpl
implements TypeScriptEntityName,
BindablePsiReference {
    public TypeScriptEntityNameImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(this.getContainingFile(), this, new JSResolveUtil.Resolver<TypeScriptEntityNameImpl>(){

            @Override
            public ResolveResult[] doResolve() {
                ResolveResult[] results;
                String referenceName = TypeScriptEntityNameImpl.this.getReferenceName();
                if (referenceName == null) {
                    return ResolveResult.EMPTY_ARRAY;
                }
                TypeScriptEntityName qualifier = TypeScriptEntityNameImpl.this.getQualifier();
                if (qualifier == null) {
                    ResolveResult[] localResult;
                    TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor(referenceName, TypeScriptEntityNameImpl.this.getContainingFile(), (PsiElement)TypeScriptEntityNameImpl.this);
                    processor.setLocalResolve(true);
                    JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)TypeScriptEntityNameImpl.this, null, processor, false, false, null);
                    HashSet resultsSet = ContainerUtil.newHashSet();
                    ArrayList results2 = ContainerUtil.newArrayList();
                    for (ResolveResult result : localResult = processor.getResultsAsResolveResults()) {
                        if (!(result.getElement() instanceof TypeScriptImportStatement) && !(result.getElement() instanceof TypeScriptModule)) continue;
                        resultsSet.add(result.getElement());
                        results2.add(result);
                    }
                    processor = new TypeScriptResolveProcessor(referenceName, TypeScriptEntityNameImpl.this.getContainingFile(), (PsiElement)TypeScriptEntityNameImpl.this);
                    TypeScriptResolveHelper.processGlobalThings(processor, ResolveState.initial(), (PsiElement)TypeScriptEntityNameImpl.this);
                    ResolveResult[] globalResults = processor.getResultsAsResolveResults();
                    if (globalResults.length == 0) {
                        return results2.toArray(new ResolveResult[results2.size()]);
                    }
                    if (results2.size() == 0) {
                        return globalResults;
                    }
                    for (ResolveResult result : globalResults) {
                        if (resultsSet.contains(result.getElement())) continue;
                        results2.add(result);
                    }
                    return results2.toArray(new ResolveResult[results2.size()]);
                }
                TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor(referenceName, TypeScriptEntityNameImpl.this.getContainingFile(), (PsiElement)TypeScriptEntityNameImpl.this);
                for (ResolveResult result : results = qualifier.multiResolve(false)) {
                    processor.setLocalResolve(false);
                    PsiElement element = result.getElement();
                    if (element instanceof TypeScriptImportStatement && result.isValidResult()) {
                        Collection referencedElements = ((TypeScriptImportStatement)element).findReferencedElements();
                        for (PsiElement referencedElement : referencedElements) {
                            if (!(referencedElement instanceof TypeScriptModule) && !(referencedElement instanceof JSFile)) continue;
                            referencedElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), referencedElement, (PsiElement)TypeScriptEntityNameImpl.this);
                        }
                    }
                    if (!(element instanceof TypeScriptModule)) continue;
                    processor.setLocalResolve(true);
                    element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), element, (PsiElement)TypeScriptEntityNameImpl.this);
                }
                return processor.getResultsAsResolveResults();
            }
        });
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptEntityNameImpl", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    public TypeScriptEntityName getQualifier() {
        return (TypeScriptEntityName)this.findChildByType(TypeScriptElementTypes.ENTITY_NAME);
    }

    public PsiReference getReference() {
        return this;
    }

    @Nullable
    public String getReferenceName() {
        PsiElement identifier = this.getReferenceNameElement();
        return identifier != null ? identifier.getText() : null;
    }

    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode referenceNameNode = this.getNode().findChildByType(JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET);
        return referenceNameNode != null ? referenceNameNode.getPsi() : null;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement identifier = this.getReferenceNameElement();
        return new TextRange(identifier != null ? identifier.getStartOffsetInParent() : 0, this.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 && results[0].isValidResult() ? results[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptEntityNameImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Unexpected rename request");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/impl/TypeScriptEntityNameImpl", "bindToElement"));
        }
        String newName = ((PsiNamedElement)element).getName();
        String referenceName = this.getReferenceName();
        PsiElement referenceNameElement = this.getReferenceNameElement();
        if (referenceNameElement != null && newName != null && !newName.equals(referenceName)) {
            ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), newName, JavaScriptSupportLoader.TYPESCRIPT);
            ASTNode refNode = this.getNode();
            refNode.replaceChild(referenceNameElement.getNode(), nameElement);
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] results;
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (!element.getManager().areElementsEquivalent(result.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptEntityNameImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    public String getReferencedName() {
        return this.getReferenceName();
    }

    public boolean shouldCheckReferences() {
        return true;
    }

    public boolean isAttributeReference() {
        return false;
    }

    @Nullable
    public JSReferenceExpression getNamespaceElement() {
        return null;
    }

    public JSExpression replace(JSExpression other) {
        throw new UnsupportedOperationException();
    }
}

