/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi.impl;

import com.intellij.javascript.JSModuleReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.impl.TypeScriptModuleTextReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptExternalModuleReferenceImpl
extends JSElementImpl
implements TypeScriptExternalModuleReference {
    private PsiReference[] myReferences;

    public TypeScriptExternalModuleReferenceImpl(ASTNode node) {
        super(node);
    }

    public ASTNode findReferenceNode() {
        return this.getNode().findChildByType(JSTokenTypes.STRING_LITERAL);
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length > 0 ? references[references.length - 1] : null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.myReferences == null) {
            this.myReferences = this.createReferences();
        }
        if (this.myReferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "getReferences"));
        }
        return this.myReferences;
    }

    @NotNull
    private PsiReference[] createReferences() {
        Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        if (pair == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = TypeScriptExternalModuleReferenceImpl.getExternalModuleReferences((PsiElement)this, (String)pair.first, ((PsiElement)pair.second).getStartOffsetInParent() + 1);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getExternalModuleReferences(final @NotNull PsiElement owner, @NotNull String refText, int offset) {
        PsiManager psiManager;
        PsiFile psiFile;
        boolean referencingExternalModuleFile;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "getExternalModuleReferences"));
        }
        if (refText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refText", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl", "getExternalModuleReferences"));
        }
        final String requiredModuleName = StringUtil.replaceChar((String)StringUtil.unquoteString((String)refText), (char)'\\', (char)'/');
        PsiFile file = owner.getContainingFile().getOriginalFile();
        final Project project = owner.getProject();
        final VirtualFile initialPath = TypeScriptUtil.findFileByReferencePath(file, requiredModuleName, project);
        boolean bl = referencingExternalModuleFile = requiredModuleName.startsWith(".") || initialPath != null;
        if (!requiredModuleName.startsWith(".") && initialPath != null && (psiFile = (psiManager = PsiManager.getInstance((Project)project)).findFile(initialPath)) instanceof JSFile) {
            referencingExternalModuleFile = ((JSFile)psiFile).isCommonJSModule();
        }
        if (referencingExternalModuleFile && !TypeScriptUtil.hasExternalModuleWithNameInFileContext(requiredModuleName, owner)) {
            return new TypeScriptReferenceContributor.FileReferenceSetWithDefaultContext(requiredModuleName, owner, offset, null, false, false){

                @Override
                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    VirtualFile path;
                    if (!requiredModuleName.startsWith(".") && (path = initialPath) != null) {
                        String s = StringUtil.replaceChar((String)requiredModuleName, (char)'/', (char)'\\');
                        for (int i = StringUtil.countChars((CharSequence)s, (char)'\\'); i > 0; --i) {
                            path = path.getParent();
                        }
                        PsiDirectory directory = owner.getManager().findDirectory(path.getParent());
                        if (directory != null) {
                            Set<PsiDirectory> set = Collections.singleton(directory);
                            if (set == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl$1", "computeDefaultContexts"));
                            }
                            return set;
                        }
                    }
                    Collection<PsiFileSystemItem> collection = super.computeDefaultContexts();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/impl/TypeScriptExternalModuleReferenceImpl$1", "computeDefaultContexts"));
                    }
                    return collection;
                }

                public FileReference createFileReference(TextRange textRange, int i, String text) {
                    return new JSModuleReference(text, i, textRange, this, TypeScriptReferenceContributor.TYPESCRIPT_EXTENSIONS);
                }
            }.getAllReferences();
        }
        JSReferenceSet references = new JSReferenceSet(owner, refText, offset, false){

            @Override
            protected JSTextReference createTextReference(String s, int offset, boolean methodRef) {
                return new TypeScriptModuleTextReference(s, offset, methodRef, project, this);
            }
        };
        return references.getReferences();
    }

    public ResolveResult[] multiResolve() {
        PsiReference reference = this.getReference();
        return reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myReferences = null;
    }
}

