/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi.impl;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;

public class TypeScriptModuleTextReference
extends JSTextReference {
    private final int myOffset;
    private final Project myProject;

    public TypeScriptModuleTextReference(String text, int offset, boolean methodRef, Project project, JSReferenceSet refSet) {
        super(refSet, text, offset, methodRef);
        this.myOffset = offset;
        this.myProject = project;
    }

    @Override
    public TextRange getRangeInElement() {
        int index = this.myOffset + this.getCanonicalText().length() - 2;
        if (index >= this.myOffset) {
            return new TextRange(this.myOffset, index);
        }
        return super.getRangeInElement();
    }

    @Override
    protected ResolveResult[] doResolve(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/psi/impl/TypeScriptModuleTextReference", "doResolve"));
        }
        return TypeScriptUtil.findExternalModule(psiFile.getOriginalFile(), this.getCanonicalText(), this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }
}

