/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeHelper
extends JSTypeHelper {
    private static final JSTypeHelper ourTypeHelper = new TypeScriptTypeHelper();

    private TypeScriptTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    @Override
    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "isAssignableToNamedType"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "isAssignableToNamedType"));
        }
        if (rOpType instanceof JSRecordTypeImpl || rOpType instanceof JSFunctionTypeImpl || rOpType instanceof JSArrayTypeImpl) {
            JSType lOpResolvedType = lOpType.substitute();
            if (lOpResolvedType != lOpType) {
                return lOpResolvedType.isDirectlyAssignableType(rOpType, processingContext);
            }
        } else if (rOpType instanceof JSGenericTypeImpl) {
            String rOpQName;
            String lOpQName;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if (!JSTypeCastUtil.startRecursiveTypesComparison(lOpQName = lOpType.getResolvedTypeText(), rOpQName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true), processingContext)) {
                return true;
            }
            JSRecordTypeImpl rOpResolvedType = TypeScriptTypeParser.buildResolvedType(rOpType);
            return lOpType.isDirectlyAssignableType(rOpResolvedType, processingContext);
        }
        return super.isAssignableToNamedType(lOpType, rOpType, processingContext);
    }

    @Override
    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @Nullable ProcessingContext processingContext) {
        JSRecordType jSRecordType;
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesAssignable"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesAssignable"));
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (!JSTypeCastUtil.startRecursiveTypesComparison(lOpType, rOpType, processingContext)) {
            return true;
        }
        Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(lOpType);
        Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rOpType);
        for (PsiElement psiElement : lOpElements) {
            if (psiElement instanceof TypeScriptTypeAlias) continue;
            for (PsiElement psiElement2 : rOpElements) {
                if (psiElement2 instanceof TypeScriptTypeAlias) continue;
                if (psiElement instanceof JSClass && psiElement2 instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)psiElement2, (JSClass)psiElement, false)) {
                    return true;
                }
                if ((!(psiElement instanceof TypeScriptEnum) || !(rOpType instanceof JSNumberType)) && (!(psiElement2 instanceof TypeScriptEnum) || !(lOpType instanceof JSNumberType))) continue;
                return true;
            }
        }
        JSRecordType lOpResolvedType = lOpType.asRecordType();
        boolean result = lOpResolvedType.isDirectlyAssignableType((JSType)(jSRecordType = rOpType.asRecordType()), processingContext);
        if (!result) {
            JSTypeCastUtil.endRecursiveTypesComparison(lOpType, rOpType, processingContext);
        }
        return result;
    }
}

