/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptConfigImpl
implements TypeScriptConfig {
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Map<String, String> myOptions;
    @NotNull
    private final VirtualFile myDirectory;
    @NotNull
    private final Collection<VirtualFile> myIncludedFiles;
    @NotNull
    private final Collection<VirtualFile> myExcludeFiles;
    @NotNull
    private final TypeScriptConfig.Target myTarget;

    @Nullable
    public static TypeScriptConfig getConfig(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfig"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!(rawFile instanceof JsonFile)) {
            return null;
        }
        JsonFile file = (JsonFile)rawFile;
        VirtualFile configVirtualFile = rawFile.getVirtualFile();
        VirtualFile configFile = file.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDirectory = configFile.getParent();
        if (configDirectory == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        if (jsonObject == null) {
            return new TypeScriptConfigImpl(configVirtualFile, ContainerUtil.newHashMap(), configDirectory, ContainerUtil.emptyList(), ContainerUtil.emptyList());
        }
        JsonProperty filesProperty = jsonObject.findProperty("files");
        JsonProperty excludeProperty = jsonObject.findProperty("exclude");
        JsonProperty compilerOptionsProperty = jsonObject.findProperty("compilerOptions");
        Map<String, String> options = TypeScriptConfigImpl.getCompilerOptions(compilerOptionsProperty);
        Collection<VirtualFile> files = TypeScriptConfigImpl.getFiles(filesProperty);
        Collection<VirtualFile> excludesFiles = TypeScriptConfigImpl.getFiles(excludeProperty);
        return new TypeScriptConfigImpl(configVirtualFile, options, configDirectory, files, excludesFiles);
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(@Nullable JsonProperty filesProperty) {
        if (filesProperty == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
            }
            return list;
        }
        JsonValue value = filesProperty.getValue();
        if (value == null || !(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
            }
            return list;
        }
        HashSet files = ContainerUtil.newHashSet();
        JsonArray arrayWithFiles = (JsonArray)value;
        for (JsonValue jsonValue : arrayWithFiles.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            for (PsiReference reference : jsonValue.getReferences()) {
                PsiElement resolve = reference.resolve();
                if (!(resolve instanceof PsiFile)) continue;
                files.add(((PsiFile)resolve).getVirtualFile());
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, String> getCompilerOptions(@Nullable JsonProperty compilerOptionsProperty) {
        HashMap result = ContainerUtil.newHashMap();
        if (compilerOptionsProperty == null || compilerOptionsProperty.getValue() == null) {
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
            }
            return hashMap;
        }
        JsonValue value = compilerOptionsProperty.getValue();
        if (!(value instanceof JsonObject)) {
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
            }
            return hashMap;
        }
        JsonObject jsonObject = (JsonObject)value;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            String optionName = property.getName();
            JsonValue optionValue = property.getValue();
            if (optionValue == null) continue;
            result.put(StringUtil.unquoteString((String)optionName), optionValue.getText());
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
        }
        return hashMap;
    }

    private TypeScriptConfigImpl(@NotNull VirtualFile configFile, @NotNull Map<String, String> options, @NotNull VirtualFile configDir, @NotNull Collection<VirtualFile> acceptedFiles, @NotNull Collection<VirtualFile> excludeFiles) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDir", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (acceptedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "acceptedFiles", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (excludeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeFiles", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        this.myConfigFile = configFile;
        this.myOptions = options;
        this.myDirectory = configDir;
        this.myIncludedFiles = acceptedFiles;
        this.myExcludeFiles = excludeFiles;
        String optionValue = this.myOptions.get("target");
        this.myTarget = StringUtil.isEmpty((String)optionValue) ? DEFAULT_TARGET : TypeScriptConfigImpl.parseTarget(optionValue);
    }

    @Override
    public boolean isIncludeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isIncludeFile"));
        }
        return TypeScriptConfigImpl.containsFile(file, this.myIncludedFiles, this.myDirectory) && !TypeScriptConfigImpl.containsFile(file, this.myExcludeFiles, null);
    }

    private static boolean containsFile(@NotNull VirtualFile file, Collection<VirtualFile> files, VirtualFile defaultDirectory) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "containsFile"));
        }
        if (files.size() > 0) {
            for (VirtualFile includedFile : files) {
                if ((!includedFile.isDirectory() || !VfsUtilCore.isAncestor((VirtualFile)includedFile, (VirtualFile)file, (boolean)true)) && (includedFile.isDirectory() || !includedFile.equals(file))) continue;
                return true;
            }
            return false;
        }
        return defaultDirectory != null && VfsUtilCore.isAncestor((VirtualFile)defaultDirectory, (VirtualFile)file, (boolean)true);
    }

    @Override
    public boolean isDirectoryBased() {
        return this.myIncludedFiles.isEmpty();
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfigFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public TypeScriptConfig.Target getTarget() {
        TypeScriptConfig.Target target = this.myTarget;
        if (target == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTarget"));
        }
        return target;
    }

    @Override
    @Nullable
    public String getOutDirectory() {
        VirtualFile baseDirectory = this.getConfigFile().getParent();
        if (baseDirectory == null) {
            return null;
        }
        String quotedString = this.myOptions.get("outDir");
        if (quotedString == null) {
            return null;
        }
        String directoryPath = StringUtil.unquoteString((String)quotedString);
        return TypeScriptConfigUtil.getOutDirectory(baseDirectory, directoryPath);
    }

    public String toString() {
        return "TypeScriptConfigImpl{myConfigFile=" + this.myConfigFile + ", myOptions=" + this.myOptions + ", myDirectory=" + this.myDirectory + ", myIncludedFiles=" + this.myIncludedFiles + '}';
    }

    public static TypeScriptConfig.Target parseTarget(String value) {
        String lowerCaseValue = StringUtil.unquoteString((String)StringUtil.toLowerCase((String)value.trim()));
        if ("es3".equals(lowerCaseValue)) {
            return TypeScriptConfig.Target.ES3;
        }
        if ("es6".equals(lowerCaseValue)) {
            return TypeScriptConfig.Target.ES6;
        }
        return DEFAULT_TARGET;
    }
}

