/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.inspections.TypeScriptValidateJSTypesInspection;
import com.intellij.lang.typescript.inspections.TypeScriptValidateTypesInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class TypeScriptTypeChecker
extends JSTypeChecker<Annotation> {
    private final JSProblemReporter<Annotation> myReporter;

    public TypeScriptTypeChecker(JSProblemReporter<Annotation> reporter) {
        this.myReporter = reporter;
    }

    @Override
    public Annotation registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        PsiElement reference;
        boolean isStrict = true;
        if (place.getParent() instanceof JSArgumentList && (reference = place.getParent().getParent()) instanceof JSCallExpression && (reference = ((JSCallExpression)reference).getMethodExpression()) instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)reference)) {
            isStrict = false;
        }
        String inspectionId = isStrict && (highlightType == ProblemHighlightType.GENERIC_ERROR || highlightType == ProblemHighlightType.ERROR) ? this.getValidateTypesInspectionId() : TypeScriptValidateJSTypesInspection.SHORT_NAME;
        return this.myReporter.registerProblem(place, message, null, inspectionId, fixes);
    }

    @Override
    public void checkTypesInReturnStatement(JSReturnStatement node) {
        JSExpression expression = node.getExpression();
        if (expression == null) {
            return;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
        if (fun == null || fun.isGenerator()) {
            return;
        }
        PsiElement returnTypeElement = fun.getReturnTypeElement();
        boolean isAsync = ES6PsiUtil.isAsyncContext(fun);
        if (returnTypeElement == null && isAsync) {
            return;
        }
        JSType type = fun.getReturnType();
        if (isAsync && type != null) {
            type = JSTypeUtils.getPromiseComponentType(type);
        }
        if (type instanceof TypeScriptTypePredicateTypeImpl) {
            type = ((TypeScriptTypePredicateTypeImpl)type).asBoolean();
        }
        this.checkExpressionIsAssignableToType(expression, type, "javascript.returned.expression.type.mismatch", (PsiElement)fun);
    }

    @Override
    public void checkExpressionIsAssignableToVariable(JSVariable p, JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        JSType type = null;
        if (p.getTypeElement() != null || p.getInitializer() != expr) {
            type = p.getType();
        }
        this.checkExpressionIsAssignableToType(expr, type, problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null));
    }

    @Override
    protected String getValidateTypesInspectionId() {
        return TypeScriptValidateTypesInspection.SHORT_NAME;
    }
}

