/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.JSDuplicatesProfile;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import org.jetbrains.annotations.NotNull;

public class JSMatchingStrategy
extends JSElementVisitor
implements MatchingStrategy {
    private static final JSMatchingStrategy ourInstance = new JSMatchingStrategy((Language)JavascriptLanguage.INSTANCE);
    private static final JSMatchingStrategy ourInstanceEcma = new JSMatchingStrategy(JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    private boolean result;
    private final Language myLanguage;

    private JSMatchingStrategy(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/structuralsearch/JSMatchingStrategy", "<init>"));
        }
        this.result = false;
        this.myLanguage = language;
    }

    public static JSMatchingStrategy getInstance() {
        return ourInstance;
    }

    public static JSMatchingStrategy getInstanceEcma() {
        return ourInstanceEcma;
    }

    public void visitElement(PsiElement element) {
        super.visitElement(element);
        if (element instanceof JSFile) {
            this.result = true;
        }
        if (JSDuplicatesProfile.getLanguageForElement(element) != this.myLanguage) {
            this.result = false;
        }
    }

    public void visitJSSourceElement(JSElement node) {
        this.result = true;
        super.visitJSSourceElement(node);
    }

    public void visitJSExpression(JSExpression node) {
        this.result = true;
        super.visitJSExpression(node);
    }

    public void visitJSVariable(JSVariable node) {
        this.result = true;
        super.visitJSVariable(node);
    }

    public void visitJSProperty(JSProperty node) {
        this.result = true;
        super.visitJSProperty(node);
    }

    public void visitJSCaseClause(JSCaseClause node) {
        this.result = true;
        super.visitJSCaseClause(node);
    }

    public void visitJSCatchBlock(JSCatchBlock node) {
        this.result = true;
        super.visitJSCatchBlock(node);
    }

    public void visitJSArgumentList(JSArgumentList node) {
        this.result = true;
        super.visitJSArgumentList(node);
    }

    public void visitJSParameterList(JSParameterList node) {
        this.result = true;
        super.visitJSParameterList(node);
    }

    public void visitJSFunctionDeclaration(JSFunction node) {
        this.result = true;
        super.visitJSFunctionDeclaration(node);
    }

    public void visitJSFunctionExpression(JSFunctionExpression node) {
        this.result = true;
        super.visitJSFunctionExpression(node);
    }

    public void visitJSClass(JSClass aClass) {
        this.result = true;
        super.visitJSClass(aClass);
    }

    public void visitJSAttributeList(JSAttributeList attributeList) {
        this.result = true;
        super.visitJSAttributeList(attributeList);
    }

    public boolean continueMatching(PsiElement start) {
        this.result = false;
        start.accept((PsiElementVisitor)this);
        return this.result;
    }

    public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        return false;
    }
}

