/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.dataflow.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableJSInspectionBase
extends JavaScriptInspection {
    public boolean m_ignoreImmediatelyReturnedVariables = false;
    public boolean m_ignoreAnnotatedVariables = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("redundant.local.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.DATA_FLOW_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("redundant.local.variable.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreImmediatelyReturnedVariables");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unnecessary.local.variable.problem.descriptor", ((PsiElement)args[0]).getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        public void visitJSVarStatement(@NotNull JSVarStatement varStatement) {
            JSVariable[] variables;
            if (varStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varStatement", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase$UnnecessaryLocalVariableVisitor", "visitJSVarStatement"));
            }
            super.visitJSVarStatement(varStatement);
            for (JSVariable variable : variables = varStatement.getVariables()) {
                if (this.isCopyVariable(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!UnnecessaryLocalVariableJSInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!UnnecessaryLocalVariableJSInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (this.isImmediatelyAssigned(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!this.isImmediatelyAssignedAsDeclaration(variable)) continue;
                this.registerVariableError(variable);
            }
        }

        private boolean isCopyVariable(final JSVariable variable) {
            JSExpression initializer = variable.getInitializer();
            if (initializer == null || !(initializer instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((JSReferenceExpression)initializer).resolve();
            if (referent == null || !(referent instanceof JSVariable) || JSResolveUtil.findParent(referent) instanceof JSClass) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            final JSStatement nextStatement = this.getNextStatement((JSStatement)declarationStatement);
            if (nextStatement == null) {
                return false;
            }
            PsiElement containingScope = variable.getDeclarationScope();
            if (containingScope instanceof JSFunction) {
                JSSourceElement[] body = ((JSFunction)containingScope).getBody();
                if (body.length == 0) {
                    return false;
                }
                containingScope = body[0];
            }
            if (containingScope == null) {
                return false;
            }
            final String name = variable.getName();
            if (name == null) {
                return false;
            }
            final Ref usedAnywhere = Ref.create((Object)Boolean.FALSE);
            final Ref usedWithinClosure = Ref.create((Object)Boolean.FALSE);
            final Ref canBeCopy = Ref.create((Object)Boolean.TRUE);
            containingScope.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
                private boolean withinNextStatement = false;
                private boolean withinClosure = false;

                public void visitElement(PsiElement element) {
                    if (!((Boolean)canBeCopy.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                    boolean _withinClosure = this.withinClosure;
                    this.withinClosure = true;
                    super.visitJSFunctionDeclaration(node);
                    this.withinClosure = _withinClosure;
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                    boolean _withinClosure = this.withinClosure;
                    this.withinClosure = true;
                    super.visitJSFunctionExpression(node);
                    this.withinClosure = _withinClosure;
                }

                public void visitJSStatement(JSStatement node) {
                    if (nextStatement == node) {
                        this.withinNextStatement = true;
                    }
                    super.visitJSStatement(node);
                    if (nextStatement == node) {
                        this.withinNextStatement = false;
                    }
                }

                public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                    JSExpression expression;
                    JSExpression lOperand = node.getLOperand();
                    if (lOperand instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null && Comparing.equal((String)((JSReferenceExpression)expression).getReferencedName(), (String)name)) {
                        canBeCopy.set((Object)Boolean.FALSE);
                    }
                    super.visitJSAssignmentExpression(node);
                }

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (node.getQualifier() == null && Comparing.equal((String)node.getReferencedName(), (String)name) && node.resolve() == variable && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                        if (((Boolean)usedAnywhere.get()).booleanValue()) {
                            canBeCopy.set((Object)Boolean.FALSE);
                        }
                        usedAnywhere.set((Object)Boolean.TRUE);
                        if (!this.withinNextStatement) {
                            canBeCopy.set((Object)Boolean.FALSE);
                        }
                        if (this.withinClosure) {
                            usedWithinClosure.set((Object)Boolean.TRUE);
                        }
                    }
                    super.visitJSReferenceExpression(node);
                }
            });
            return (Boolean)canBeCopy.get() != false && (Boolean)usedAnywhere.get() != false && (Boolean)usedWithinClosure.get() == false;
        }

        private boolean isImmediatelyReturned(JSVariable variable) {
            boolean immediatelyReturned;
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            JSStatement nextStatement = this.getNextStatement((JSStatement)declarationStatement);
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSReturnStatement)) {
                return false;
            }
            JSReturnStatement returnStatement = (JSReturnStatement)nextStatement;
            JSExpression returnValue = returnStatement.getExpression();
            if (returnValue == null) {
                return false;
            }
            if (!(returnValue instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)returnValue).resolve();
            boolean bl = immediatelyReturned = referent != null && referent.equals(variable);
            if (immediatelyReturned && ReferencesSearch.search((PsiElement)variable).findAll().size() > 1) {
                return false;
            }
            return immediatelyReturned;
        }

        private JSStatement getNextStatement(JSStatement statement) {
            return (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, JSStatement.class);
        }

        private boolean isImmediatelyThrown(JSVariable variable) {
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            JSStatement nextStatement = this.getNextStatement((JSStatement)declarationStatement);
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSThrowStatement)) {
                return false;
            }
            JSThrowStatement throwStatement = (JSThrowStatement)nextStatement;
            JSExpression returnValue = throwStatement.getExpression();
            if (returnValue == null) {
                return false;
            }
            if (!(returnValue instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)returnValue).resolve();
            return referent != null && referent.equals(variable);
        }

        private boolean isImmediatelyAssigned(JSVariable variable) {
            JSBlockStatement containingScope = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
            if (containingScope == null) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            JSStatement nextStatement = null;
            int followingStatementNumber = 0;
            JSStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSExpressionStatement)) {
                return false;
            }
            JSExpressionStatement expressionStatement = (JSExpressionStatement)nextStatement;
            JSExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof JSAssignmentExpression)) {
                return false;
            }
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)expression;
            JSExpression rhs = assignmentExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression reference = (JSReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            JSExpression lhs = assignmentExpression.getLOperand();
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)lhs)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[i])) continue;
                return false;
            }
            return !VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[followingStatementNumber - 2]);
        }

        private boolean isImmediatelyAssignedAsDeclaration(JSVariable variable) {
            JSBlockStatement containingScope = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
            if (containingScope == null) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            JSStatement nextStatement = null;
            int followingStatementNumber = 0;
            JSStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement declaration = (JSVarStatement)nextStatement;
            JSVariable[] declarations = declaration.getVariables();
            if (declarations.length != 1) {
                return false;
            }
            JSExpression rhs = declarations[0].getInitializer();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[i])) continue;
                return false;
            }
            return true;
        }
    }
}

