/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ParameterNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.parameter.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/naming/ParameterNamingConventionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.NAMING_CONVENTIONS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/naming/ParameterNamingConventionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSParameter parameter = (JSParameter)((PsiElement)args[0]).getParent();
        assert (parameter != null);
        String parameterName = parameter.getName();
        if (parameterName.length() < this.getMinLength()) {
            return InspectionJSBundle.message("parameter.name.is.too.short.error.string", new Object[0]);
        }
        if (parameterName.length() > this.getMaxLength()) {
            return InspectionJSBundle.message("parameter.name.is.too.long.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("parameter.name.doesnt.match.regex.error.string", this.getRegex());
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
            JSParameter[] parameters;
            super.visitJSFunctionDeclaration(function);
            for (JSParameter variable : parameters = function.getParameters()) {
                String name = variable.getName();
                if (name == null || ParameterNamingConventionJSInspection.this.isValid(name)) continue;
                this.registerVariableError((JSVariable)variable);
            }
        }
    }
}

