/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.scope;

import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringWebCustomBeanScope
extends SpringCustomBeanScope {
    @NonNls
    private static final String GENERIC_PORTLET_BEAN = "org.springframework.web.portlet.GenericPortletBean";
    @NonNls
    private static final String REQUEST_CONTEXT_LISTENER = "org.springframework.web.context.request.RequestContextListener";
    @NonNls
    private static final String REQUEST_CONTEXT_FILTER = "org.springframework.web.filter.RequestContextFilter";
    @NonNls
    private static final String MVC_DISPATCHER_SERVLET = "org.springframework.web.servlet.DispatcherServlet";

    public String getScopeClassName() {
        return REQUEST_CONTEXT_LISTENER;
    }

    public boolean process(List<SpringBeanScope> scopes, Set<SpringModel> models, @NotNull PsiClass scopeClass, PsiElement psiElement) {
        if (scopeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeClass", "com/intellij/spring/model/scope/SpringWebCustomBeanScope", "process"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        assert (module != null);
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        if (javaPsiFacade.findClass(GENERIC_PORTLET_BEAN, searchScope) != null) {
            scopes.add(new SpringBeanScope("globalSession"));
        }
        if (javaPsiFacade.findClass(MVC_DISPATCHER_SERVLET, searchScope) != null) {
            SpringWebCustomBeanScope.addWebScopes(scopes);
            return true;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet facet : webFacets) {
            WebModel webModel = facet.getWebModel();
            for (CommonListener listener : webModel.getListeners()) {
                if (!InheritanceUtil.isInheritor((PsiClass)listener.getPsiClass(), (String)REQUEST_CONTEXT_LISTENER)) continue;
                SpringWebCustomBeanScope.addWebScopes(scopes);
                return true;
            }
            for (CommonFilter filter : webModel.getFilters()) {
                if (!InheritanceUtil.isInheritor((PsiClass)filter.getPsiClass(), (String)REQUEST_CONTEXT_FILTER)) continue;
                SpringWebCustomBeanScope.addWebScopes(scopes);
                return true;
            }
        }
        return true;
    }

    private static void addWebScopes(List<SpringBeanScope> scopes) {
        scopes.add(new SpringBeanScope("request"));
        scopes.add(new SpringBeanScope("session"));
    }
}

