/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger.values;

import com.intellij.javascript.trace.debugger.values.TraceValueManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.ValueType;

public class TraceString
implements StringValue {
    private TraceValueManager myValueManager;
    private String myExpression;
    private final boolean myIsTruncated;
    private final int myLength;
    private String myValue;

    public TraceString(@NotNull TraceValueManager valueManager, @NotNull String expression, int length, String value) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/trace/debugger/values/TraceString", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/values/TraceString", "<init>"));
        }
        this.myValueManager = valueManager;
        this.myExpression = expression;
        this.myIsTruncated = length > StringUtil.notNullize((String)value).length();
        this.myLength = length;
        this.myValue = value;
        this.myValueManager = valueManager;
        this.myExpression = expression;
    }

    public boolean isTruncated() {
        return this.myIsTruncated;
    }

    public int getLength() {
        return this.myLength;
    }

    public Promise<String> getFullString() {
        return this.myValueManager.getFullString(this.myExpression).done((Consumer)new Consumer<String>(){

            public void consume(String s) {
                TraceString.this.myValue = s;
            }
        });
    }

    @NotNull
    public ValueType getType() {
        ValueType valueType = ValueType.STRING;
        if (valueType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceString", "getType"));
        }
        return valueType;
    }

    public String getValueString() {
        return this.myValue;
    }
}

