/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger.values;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.debugger.TraceSessionEvaluator;
import com.intellij.javascript.trace.debugger.values.TraceArray;
import com.intellij.javascript.trace.debugger.values.TraceObject;
import com.intellij.javascript.trace.debugger.values.TraceString;
import com.intellij.javascript.trace.execution.common.PropertyMetadata;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Range;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public class TraceValueManager
extends ValueManager {
    private final TraceSessionEvaluator myEvaluator;
    private final PsiElement myPosition;

    public TraceValueManager(TraceSessionEvaluator evaluator, PsiElement position) {
        this.myEvaluator = evaluator;
        this.myPosition = position;
    }

    public void loadProperties(final @NotNull String expression, final @NotNull AsyncResult<List<Variable>> result) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "loadProperties"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "loadProperties"));
        }
        this.myEvaluator.evaluateExpression(ExpressionEvaluationRequest.createPropertiesRequest(this.myPosition, expression)).done((Consumer)new Consumer<ExpressionEvaluationResult>(){

            public void consume(ExpressionEvaluationResult evaluationResult) {
                result.setDone((Object)ContainerUtil.map((Object[])evaluationResult.getProperties(), (Function)new Function<PropertyMetadata, Variable>(){

                    public Variable fun(PropertyMetadata metadata) {
                        return new TraceVariable(expression, metadata);
                    }
                }));
            }
        });
    }

    @NotNull
    public Promise<ExpressionEvaluationResult> getIndexedProperties(final @NotNull String expression, int from, int to, int threshold, final @NotNull IndexedVariablesConsumer consumer) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "getIndexedProperties"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "getIndexedProperties"));
        }
        Promise promise = this.myEvaluator.evaluateExpression(ExpressionEvaluationRequest.createPropertiesRequest(this.myPosition, expression, (Range<Integer>)new Range((Comparable)Integer.valueOf(from), (Comparable)Integer.valueOf(to)), threshold)).done((Consumer)new Consumer<ExpressionEvaluationResult>(){

            public void consume(ExpressionEvaluationResult evaluationResult) {
                if (!consumer.isObsolete() && evaluationResult.getValue() != null) {
                    int[] ranges = evaluationResult.getValue().getRanges();
                    if (ranges.length > 0) {
                        consumer.consumeRanges(ranges);
                    }
                    consumer.consumeVariables(ContainerUtil.map((Object[])evaluationResult.getProperties(), (Function)new Function<PropertyMetadata, Variable>(){

                        public Variable fun(PropertyMetadata metadata) {
                            return new TraceVariable(expression, metadata);
                        }
                    }));
                }
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "getIndexedProperties"));
        }
        return promise;
    }

    @NotNull
    public Promise<String> getFullString(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "getFullString"));
        }
        Promise promise = this.myEvaluator.evaluateExpression(ExpressionEvaluationRequest.createFullStringRequest(this.myPosition, expression)).then((Function)new Function<ExpressionEvaluationResult, String>(){

            public String fun(ExpressionEvaluationResult result) {
                PropertyMetadata value = result.getValue();
                return value == null ? TraceBundle.message("console.trace.evaluation.noFullStringValue", new Object[0]) : value.getPrimitiveValue();
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceValueManager", "getFullString"));
        }
        return promise;
    }

    public Value createValue(String expression, PropertyMetadata obj) {
        if (obj == null) {
            return new PrimitiveValue(ValueType.NULL, TraceBundle.message("console.trace.evaluation.noValue", new Object[0]));
        }
        String type = obj.getType();
        if (type.equals("Undefined")) {
            return PrimitiveValue.UNDEFINED;
        }
        if (type.equals("Null")) {
            return PrimitiveValue.NULL;
        }
        if (type.equals("Number")) {
            return new PrimitiveValue(ValueType.NUMBER, obj.getPrimitiveValue());
        }
        if (type.equals("Boolean")) {
            return new PrimitiveValue(ValueType.BOOLEAN, obj.getPrimitiveValue());
        }
        if (type.equals("String")) {
            return new TraceString(this, expression, obj.getLength(), obj.getPrimitiveValue());
        }
        if (type.equals("Array")) {
            return new TraceArray(this, expression, obj.getLength());
        }
        if (type.equals("Function")) {
            return new TraceObject(ValueType.OBJECT, this, expression, type, TraceValueManager.hasProperties(obj), obj.getParams() != null ? String.format(TraceBundle.message("console.trace.evaluation.function", new Object[0]), obj.getParams()) : type, obj.getLength());
        }
        return new TraceObject(ValueType.OBJECT, this, expression, type, TraceValueManager.hasProperties(obj), obj.getPrimitiveValue(), obj.getLength());
    }

    private static ThreeState hasProperties(PropertyMetadata obj) {
        return obj.isEmpty() ? ThreeState.NO : ThreeState.YES;
    }

    private class TraceVariable
    implements Variable {
        private final String myExpression;
        private final PropertyMetadata myMetadata;
        private final String myName;

        private TraceVariable(String expression, PropertyMetadata metadata) {
            this.myMetadata = metadata;
            this.myExpression = expression + "['" + metadata.getNormalizedName() + "']";
            this.myName = metadata.getName();
        }

        public boolean isReadable() {
            return true;
        }

        @Nullable
        public Value getValue() {
            return TraceValueManager.this.createValue(this.myExpression, this.myMetadata);
        }

        public void setValue(Value value) {
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/debugger/values/TraceValueManager$TraceVariable", "getName"));
            }
            return string;
        }

        public boolean isMutable() {
            return false;
        }

        @Nullable
        public ValueModifier getValueModifier() {
            return null;
        }
    }
}

