/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.editor;

import com.intellij.javascript.trace.editor.TraceResultTextAttributes;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TraceLinePainter
extends EditorLinePainter {
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project, @NotNull VirtualFile file, int lineNumber) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/editor/TraceLinePainter", "getLineExtensions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/editor/TraceLinePainter", "getLineExtensions"));
        }
        if (!(file instanceof TraceVirtualFile)) {
            return null;
        }
        if (!Registry.is((String)"ide.debugger.inline")) {
            return null;
        }
        TraceVirtualFile traceVirtualFile = (TraceVirtualFile)file;
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors(file);
        if (editors.length == 0 || !(editors[0] instanceof TextEditor)) {
            return null;
        }
        TextEditor textEditor = (TextEditor)editors[0];
        Editor editor = textEditor.getEditor();
        String extension = traceVirtualFile.getLineExtension(editor, lineNumber);
        if (StringUtil.isEmpty((String)extension)) {
            return null;
        }
        ArrayList<LineExtensionInfo> lineExtensions = new ArrayList<LineExtensionInfo>();
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(TraceResultTextAttributes.EXECUTION_TIME);
        lineExtensions.add(new LineExtensionInfo("  " + extension, attributes.getForegroundColor(), attributes.getEffectType(), attributes.getEffectColor(), attributes.getFontType()));
        return lineExtensions;
    }
}

