/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.execution.TraceBrowserRunConfigurationSettings;
import com.intellij.javascript.trace.execution.TraceLimits;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceBrowserSettingsSerializationUtil {
    private static final String CONFIG = "config";
    private static final String HAS_CONFIG = "has-config";
    private static final String SYSTEM_PROXY = "system-proxy";
    private static final String PROXY_PORT = "proxy-port";
    private static final String NODE = "node";
    private static final String OPEN_BROWSER = "open-browser";
    private static final String BROWSER = "browser";

    private TraceBrowserSettingsSerializationUtil() {
    }

    public static TraceBrowserRunConfigurationSettings readFromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceBrowserSettingsSerializationUtil", "readFromXml"));
        }
        String nodePath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceBrowserSettingsSerializationUtil.getAttrValue(element, NODE)));
        boolean hasConfig = Boolean.parseBoolean(StringUtil.notNullize((String)TraceBrowserSettingsSerializationUtil.getAttrValue(element, HAS_CONFIG), (String)"false"));
        String pathOrUrl = StringUtil.notNullize((String)TraceBrowserSettingsSerializationUtil.getAttrValue(element, CONFIG));
        String configOrUrl = hasConfig ? FileUtil.toSystemDependentName((String)pathOrUrl) : pathOrUrl;
        String proxyPortAttrValue = TraceBrowserSettingsSerializationUtil.getAttrValue(element, PROXY_PORT);
        String browserId = StringUtil.nullize((String)TraceBrowserSettingsSerializationUtil.getAttrValue(element, BROWSER));
        boolean useSystemProxy = Boolean.parseBoolean(StringUtil.notNullize((String)TraceBrowserSettingsSerializationUtil.getAttrValue(element, SYSTEM_PROXY), (String)"false"));
        boolean needToOpenBrowser = Boolean.parseBoolean(StringUtil.notNullize((String)TraceBrowserSettingsSerializationUtil.getAttrValue(element, OPEN_BROWSER), (String)"false"));
        int proxyPort = proxyPortAttrValue == null ? 3546 : Integer.parseInt(proxyPortAttrValue);
        return new TraceBrowserRunConfigurationSettings(proxyPort, hasConfig, useSystemProxy, configOrUrl, nodePath, needToOpenBrowser, browserId, TraceLimits.readExternal(element));
    }

    @Nullable
    private static String getAttrValue(Element element, String attrKey) {
        Attribute attribute = element.getAttribute(attrKey);
        return attribute != null ? attribute.getValue() : null;
    }

    public static void writeToXml(@NotNull Element element, @NotNull TraceBrowserRunConfigurationSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceBrowserSettingsSerializationUtil", "writeToXml"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/trace/execution/TraceBrowserSettingsSerializationUtil", "writeToXml"));
        }
        element.setAttribute(NODE, FileUtil.toSystemIndependentName((String)settings.getNodePath()));
        element.setAttribute(CONFIG, settings.hasConfig() ? FileUtil.toSystemIndependentName((String)settings.getConfigPath()) : settings.getUrl());
        element.setAttribute(HAS_CONFIG, String.valueOf(settings.hasConfig()));
        element.setAttribute(SYSTEM_PROXY, String.valueOf(settings.isSystemProxyUsed()));
        element.setAttribute(PROXY_PORT, String.valueOf(settings.getProxyPort()));
        element.setAttribute(OPEN_BROWSER, String.valueOf(settings.needToOpenBrowser()));
        element.setAttribute(BROWSER, StringUtil.notNullize((String)settings.getBrowserId()));
        TraceLimits traceLimits = settings.getTraceLimits();
        if (traceLimits != null) {
            traceLimits.writeExternal(element);
        }
    }
}

