/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.nodejs.BaseNodeJSFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceServerLogComponent
implements ComponentWithActions {
    private final ConsoleView myConsole;
    private ActionGroup myActionGroup;
    private AnAction myStopAction;

    public TraceServerLogComponent(@NotNull Project project, @NotNull Disposable parent, @NotNull AnAction stopAction) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceServerLogComponent", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/TraceServerLogComponent", "<init>"));
        }
        if (stopAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAction", "com/intellij/javascript/trace/execution/TraceServerLogComponent", "<init>"));
        }
        this.myStopAction = stopAction;
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project, scope);
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new BaseNodeJSFilter(project));
        this.myConsole = builder.getConsole();
        Disposer.register((Disposable)parent, (Disposable)this.myConsole);
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        AnAction[] actions;
        if (this.myActionGroup != null) {
            return this.myActionGroup;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.myStopAction);
        for (AnAction action : actions = this.myConsole.createConsoleActions()) {
            group.add(action);
        }
        group.addSeparator();
        this.myActionGroup = group;
        return this.myActionGroup;
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        ConsoleView console = this.myConsole;
        return console == null ? null : console.getComponent();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myConsole.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceServerLogComponent", "getComponent"));
        }
        return jComponent;
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/trace/execution/TraceServerLogComponent", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/javascript/trace/execution/TraceServerLogComponent", "print"));
        }
        this.myConsole.print(text, contentType);
    }

    public void clear() {
        this.myConsole.clear();
    }
}

