/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.SpyJSIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CloseAllTraceFilesAction
extends AnAction {
    private FileEditorManager myFileEditorManager;

    public CloseAllTraceFilesAction(@NotNull FileEditorManager fileEditorManager) {
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/javascript/trace/execution/actions/CloseAllTraceFilesAction", "<init>"));
        }
        super(TraceBundle.message("console.trace.toolbar.closeAll", new Object[0]), TraceBundle.message("console.trace.toolbar.closeAll", new Object[0]), SpyJSIcons.Close_sessionStop);
        this.myFileEditorManager = fileEditorManager;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(!CloseAllTraceFilesAction.getAllOpenedTraceVirtualFiles(this.myFileEditorManager).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        this.closeFiles();
    }

    private void closeFiles() {
        for (VirtualFile file : CloseAllTraceFilesAction.getAllOpenedTraceVirtualFiles(this.myFileEditorManager)) {
            this.myFileEditorManager.closeFile(file);
        }
    }

    public static void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/actions/CloseAllTraceFilesAction", "execute"));
        }
        if (project.isDisposed()) {
            return;
        }
        new CloseAllTraceFilesAction(FileEditorManager.getInstance((Project)project)).closeFiles();
    }

    private static List<VirtualFile> getAllOpenedTraceVirtualFiles(FileEditorManager fileEditorManager) {
        return ContainerUtil.filter((Object[])fileEditorManager.getOpenFiles(), (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file instanceof TraceVirtualFile;
            }
        });
    }
}

