/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.trace.debugger.ExpressionEvaluator;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedPsiFile {
    private final int myFunctionNumber;
    private final TraceContext myTraceContext;
    private String myPath;
    private TraceSession myTraceSession;
    private PsiFile myPsiFile;
    private ExpressionEvaluator myEvaluator;
    private static final Key<Integer> TRACED_FUNCTION_ID = Key.create((String)"spy-js.traced.function.id");
    private static final Key<IndexedPsiFile> INDEXED_PSI_FILE_KEY = Key.create((String)"spy-js.indexed.psi.file");
    public static final Integer PROGRAM_ID = 1;

    private IndexedPsiFile(@NotNull TraceContext traceContext, @NotNull PsiFile psiFile, @NotNull String path) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "<init>"));
        }
        this.myTraceContext = traceContext;
        this.myPath = path;
        this.myTraceSession = traceContext.getTraceSession();
        this.myPsiFile = psiFile;
        this.subscribeToSessionEvents();
        this.myFunctionNumber = IndexedPsiFile.indexPsiFile(psiFile);
        this.myPsiFile.putUserData(INDEXED_PSI_FILE_KEY, (Object)this);
    }

    private void subscribeToSessionEvents() {
        this.myTraceSession.onTraceFileChanged(new Consumer<VirtualFile>(){

            public void consume(VirtualFile changedFile) {
                if (IndexedPsiFile.this.myPsiFile.getVirtualFile().equals(changedFile)) {
                    IndexedPsiFile.this.dispose();
                }
            }
        });
        this.myTraceSession.onSessionStopped(new Runnable(){

            @Override
            public void run() {
                IndexedPsiFile.this.dispose();
            }
        });
    }

    @Nullable
    public static IndexedPsiFile getIndexedPsiFile(@NotNull Project project, @NotNull PsiFile file, boolean forRealtimeEvaluation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "getIndexedPsiFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "getIndexedPsiFile"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        boolean isTraceFile = virtualFile instanceof OriginalTraceVirtualFile;
        IndexedPsiFile indexedPsiFile = (IndexedPsiFile)file.getUserData(INDEXED_PSI_FILE_KEY);
        if (indexedPsiFile != null) {
            return indexedPsiFile;
        }
        List descriptors = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (descriptors.isEmpty()) {
            return null;
        }
        TraceContext context = null;
        String url = null;
        for (RunContentDescriptor descriptor : descriptors) {
            TraceSettings config;
            TraceSession session;
            TraceContext traceContext;
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || (traceContext = (TraceContext)processHandler.getUserData(TraceContext.KEY)) == null || !(session = traceContext.getTraceSession()).isRunning()) continue;
            if (isTraceFile && session.getLoadedTracedSourceFiles(((TraceVirtualFile)virtualFile).getStreamId()).length > 0) {
                return new IndexedPsiFile(traceContext, file, virtualFile.getPath());
            }
            if (session.isLoaded() || (config = session.getSettings()) == null || forRealtimeEvaluation && !config.isRealtimeEvaluationEnabled() || (url = session.getRemoteTracedFile(file.getVirtualFile())) == null) continue;
            context = traceContext;
            break;
        }
        if (context == null) {
            return null;
        }
        return new IndexedPsiFile(context, file, url);
    }

    private void dispose() {
        this.myPsiFile.putUserData(INDEXED_PSI_FILE_KEY, null);
    }

    @NotNull
    public ExpressionEvaluator getEvaluator() {
        if (this.myEvaluator == null) {
            this.myEvaluator = new ExpressionEvaluator(this.myTraceSession, this, this.myTraceSession.getRemoteTracedFile(this.myPsiFile.getVirtualFile()));
        }
        ExpressionEvaluator expressionEvaluator = this.myEvaluator;
        if (expressionEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "getEvaluator"));
        }
        return expressionEvaluator;
    }

    private static int indexPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "indexPsiFile"));
        }
        final Integer[] functionId = new Integer[]{PROGRAM_ID};
        PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/common/IndexedPsiFile$3", "execute"));
                }
                if (element instanceof JSFunction) {
                    Integer id = functionId[0] = Integer.valueOf(functionId[0] + 1);
                    element.putUserData(TRACED_FUNCTION_ID, (Object)id);
                }
                return true;
            }
        });
        return functionId[0];
    }

    @Nullable
    public Integer getFunctionId(@Nullable PsiElement position) {
        Integer currentFunctionId = PROGRAM_ID;
        if (position == null) {
            return currentFunctionId;
        }
        JSFunction type = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)position, JSFunction.class);
        if (type != null) {
            currentFunctionId = (Integer)type.getUserData(TRACED_FUNCTION_ID);
        }
        return currentFunctionId;
    }

    public int getFunctionNumber() {
        return this.myFunctionNumber;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "getPsiFile"));
        }
        return psiFile;
    }

    @NotNull
    public TraceContext getContext() {
        TraceContext traceContext = this.myTraceContext;
        if (traceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/IndexedPsiFile", "getContext"));
        }
        return traceContext;
    }

    public String getPath() {
        return this.myPath;
    }
}

