/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.actions.EventNodeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AddNegatedFileToFilterAction
extends EventNodeAction {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull EventNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddNegatedFileToFilterAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddNegatedFileToFilterAction", "doUpdate"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddNegatedFileToFilterAction", "doUpdate"));
        }
        TraceProjectSettings.EventFilterState activeFilter = tree.getTraceSettingsManager().getActiveFilter();
        String[] files = context.getEvent().getFiles();
        if (files.length == 0 || !TraceProjectSettings.EventFilterState.isAllOrNothingFilter(activeFilter)) {
            e.getPresentation().setVisible(false);
            return;
        }
        e.getPresentation().setText(String.format(TraceBundle.message("console.trace.toolbar.filterEvents.captureOnlyFileTemplate", new Object[0]), Utils.getShortFileName(files[0])), false);
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull EventNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/AddNegatedFileToFilterAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/AddNegatedFileToFilterAction", "doPerform"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/AddNegatedFileToFilterAction", "doPerform"));
        }
        TraceSettingsManager traceSettingsManager = tree.getTraceSettingsManager();
        TraceProjectSettings.EventFilterState activeFilter = traceSettingsManager.getActiveFilter();
        String[] files = context.getEvent().getFiles();
        if (files.length == 0 || !TraceProjectSettings.EventFilterState.isAllOrNothingFilter(activeFilter)) {
            return;
        }
        String file = files[0];
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("file");
        condition.setValue("!" + StringUtil.escapeBackSlashes((String)file));
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, String.format(TraceBundle.message("console.trace.toolbar.filterEvents.captureOnlyNameSuggestionTemplate", new Object[0]), Utils.getShortFileName(file)));
    }
}

