/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.actions.EventStreamAction;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyRequest;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class ShowAppDependencyGraphAction
extends EventStreamAction {
    @Override
    protected void doPerform(@NotNull EventStreamNode streamNode, @NotNull EventTree context) {
        if (streamNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamNode", "com/intellij/javascript/trace/execution/events/actions/ShowAppDependencyGraphAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ShowAppDependencyGraphAction", "doPerform"));
        }
        final TraceContext traceContext = context.getTraceContext();
        if (traceContext == null) {
            return;
        }
        TraceSession session = traceContext.getTraceSession();
        String streamId = streamNode.getStreamId();
        session.getFileDependencyVirtualFile(new FileDependencyRequest(streamId, streamNode.getName()), new Consumer<FileDependencyVirtualFile>(){

            public void consume(final FileDependencyVirtualFile file) {
                file.setTraceContext(traceContext);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(traceContext.getProject(), (VirtualFile)file);
                        openFileDescriptor.navigate(true);
                    }
                });
            }
        });
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull EventStreamNode streamNode, @NotNull EventTree context) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/ShowAppDependencyGraphAction", "doUpdate"));
        }
        if (streamNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamNode", "com/intellij/javascript/trace/execution/events/actions/ShowAppDependencyGraphAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ShowAppDependencyGraphAction", "doUpdate"));
        }
        TraceContext traceContext = context.getTraceContext();
        if (traceContext == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        TraceSession session = traceContext.getTraceSession();
        if (!session.isRunning()) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }
}

