/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyGraph
extends GraphDataModel<FileNode, RuntimeDependencyEdge> {
    private HashMap<String, FileNode> myNodeHashMap;
    private HashSet<RuntimeDependencyEdge> myEdges;
    private List<Predicate<FileNode>> myNodeFilters;
    private static final int MAX_NODES = 1000;
    private String myStreamId;

    public FileDependencyGraph(@NotNull String streamId) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "<init>"));
        }
        this.myNodeHashMap = new HashMap();
        this.myEdges = new HashSet();
        this.myNodeFilters = new ArrayList<Predicate<FileNode>>();
        this.myStreamId = streamId;
    }

    @NotNull
    public Collection<FileNode> getNodes() {
        Collection fileNodes = this.myNodeHashMap.values();
        if (this.myNodeFilters.isEmpty()) {
            Collection collection = fileNodes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getNodes"));
            }
            return collection;
        }
        List list = ContainerUtil.filter((Collection)fileNodes, (Condition)new Condition<FileNode>(){

            public boolean value(FileNode fileNode) {
                return FileDependencyGraph.this.matchesAllFilters(fileNode);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getNodes"));
        }
        return list;
    }

    private boolean matchesAllFilters(final FileNode fileNode) {
        return ContainerUtil.find(this.myNodeFilters, (Condition)new Condition<Predicate<FileNode>>(){

            public boolean value(Predicate<FileNode> predicate) {
                return !predicate.apply((Object)fileNode);
            }
        }) == null;
    }

    @NotNull
    public Collection<RuntimeDependencyEdge> getEdges() {
        if (this.myNodeFilters.isEmpty()) {
            HashSet<RuntimeDependencyEdge> hashSet = this.myEdges;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getEdges"));
            }
            return hashSet;
        }
        List list = ContainerUtil.filter(this.myEdges, (Condition)new Condition<RuntimeDependencyEdge>(){

            public boolean value(RuntimeDependencyEdge edge) {
                return FileDependencyGraph.this.matchesAllFilters(edge.getSource()) && FileDependencyGraph.this.matchesAllFilters(edge.getTarget());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getEdges"));
        }
        return list;
    }

    @NotNull
    public FileNode getSourceNode(RuntimeDependencyEdge edge) {
        FileNode fileNode = edge.getSource();
        if (fileNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getSourceNode"));
        }
        return fileNode;
    }

    @NotNull
    public FileNode getTargetNode(RuntimeDependencyEdge edge) {
        FileNode fileNode = edge.getTarget();
        if (fileNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getTargetNode"));
        }
        return fileNode;
    }

    @NotNull
    public String getNodeName(FileNode node) {
        String string = node.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public String getEdgeName(RuntimeDependencyEdge edge) {
        String string = edge.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getEdgeName"));
        }
        return string;
    }

    @Nullable
    public RuntimeDependencyEdge createEdge(@NotNull FileNode from, @NotNull FileNode to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "createEdge"));
        }
        if (this.myNodeHashMap.size() >= 1000) {
            return null;
        }
        if (this.myNodeHashMap.get((Object)from.getId()) == null) {
            this.myNodeHashMap.put((Object)from.getId(), (Object)from);
        }
        if (this.myNodeHashMap.get((Object)to.getId()) == null) {
            this.myNodeHashMap.put((Object)to.getId(), (Object)to);
        }
        RuntimeDependencyEdge dependencyEdge = new RuntimeDependencyEdge(from, to);
        this.myEdges.add((Object)dependencyEdge);
        from.addOutgoingEdge(dependencyEdge);
        to.addIncomingEdge(dependencyEdge);
        return dependencyEdge;
    }

    public void dispose() {
    }

    public void addNodeFilter(@NotNull Predicate<FileNode> nodeFilter) {
        if (nodeFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeFilter", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "addNodeFilter"));
        }
        this.myNodeFilters.add(nodeFilter);
    }

    @Nullable
    public FileNode getNode(@NotNull String fileId) {
        if (fileId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileId", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getNode"));
        }
        return (FileNode)this.myNodeHashMap.get((Object)fileId);
    }

    @NotNull
    public String getStreamId() {
        String string = this.myStreamId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyGraph", "getStreamId"));
        }
        return string;
    }
}

