/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RootTreeNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyTree
extends SimpleTree
implements Disposable {
    private SimpleTreeBuilder myTreeBuilder;
    private TraceContext myContext;

    public FileDependencyTree(@NotNull TraceContext traceContext) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyTree", "<init>"));
        }
        this.setRootVisible(false);
        this.getEmptyText().setText(traceContext.getTraceSession().isRunning() ? TraceBundle.message("fileDependency.noSelection.message", new Object[0]) : TraceBundle.message("fileDependency.sessionStopped.message", new Object[0]));
        final SimpleNode stub = new SimpleNode(){

            public SimpleNode[] getChildren() {
                return new SimpleNode[0];
            }
        };
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)((Object)this), this.getBuilderModel(), (AbstractTreeStructure)new SimpleTreeStructure(){

            public Object getRootElement() {
                return stub;
            }
        }, null);
        this.myTreeBuilder.initRootNode();
        this.myTreeBuilder.updateFromRoot();
    }

    public FileDependencyTree(final @NotNull TraceContext traceContext, final @NotNull String streamId, final @NotNull FileNode fileNode, final @Nullable RuntimeDependencyEdge edge) {
        Object[] objectArray;
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyTree", "<init>"));
        }
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyTree", "<init>"));
        }
        if (fileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNode", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyTree", "<init>"));
        }
        this.myContext = traceContext;
        this.setRootVisible(false);
        this.getEmptyText().setText(traceContext.getTraceSession().isRunning() ? (edge == null && fileNode.getOutgoingEdges().length == 0 ? TraceBundle.message("fileDependency.details.noOutgoingEdges", new Object[0]) : TraceBundle.message("fileDependency.details.loading", new Object[0])) : TraceBundle.message("fileDependency.sessionStopped.message", new Object[0]));
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)actionManager.getAction("Spy-js.FileDependencyGraph.Tree");
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        ArrayList<String> fileIds = new ArrayList<String>();
        fileIds.add(fileNode.getId());
        if (edge == null) {
            objectArray = fileNode.getOutgoingEdges();
        } else {
            RuntimeDependencyEdge[] runtimeDependencyEdgeArray = new RuntimeDependencyEdge[1];
            objectArray = runtimeDependencyEdgeArray;
            runtimeDependencyEdgeArray[0] = edge;
        }
        fileIds.addAll(ContainerUtil.map((Object[])objectArray, (Function)new Function<RuntimeDependencyEdge, String>(){

            public String fun(RuntimeDependencyEdge edge) {
                return edge.getTarget().getId();
            }
        }));
        traceContext.getTraceSession().ensureFileDataLoaded(ArrayUtil.toStringArray(fileIds), new Runnable(){

            @Override
            public void run() {
                final RootTreeNode rootNode = new RootTreeNode(traceContext, streamId, fileNode, edge);
                FileDependencyTree.this.myTreeBuilder = new SimpleTreeBuilder((JTree)((Object)FileDependencyTree.this), FileDependencyTree.this.getBuilderModel(), (AbstractTreeStructure)new SimpleTreeStructure(){

                    public Object getRootElement() {
                        return rootNode;
                    }
                }, null);
                FileDependencyTree.this.myTreeBuilder.initRootNode();
                FileDependencyTree.this.myTreeBuilder.updateFromRoot();
            }
        });
    }

    public void dispose() {
        if (this.myTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myTreeBuilder);
        }
    }

    public TraceContext getContext() {
        return this.myContext;
    }
}

