/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.settings.EventFilterConditionDialog;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EventFilterPanel
extends JPanel {
    private final JBList myConditionsList;
    private final MyConditionListModel myConditionListModel;
    private final JBTextField myNameField;
    private TraceProjectSettings.EventFilterState myFilter;

    public EventFilterPanel(TraceProjectSettings.EventFilterState filter, final Consumer<String> nameChangeListener) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.myFilter = filter;
        JPanel conditionsListPanel = new JPanel(new BorderLayout());
        this.myConditionListModel = new MyConditionListModel();
        for (TraceProjectSettings.EventFilterConditionState condition : filter.getEventFilterConditions()) {
            this.myConditionListModel.addElement(condition);
        }
        this.myConditionsList = new JBList((ListModel)this.myConditionListModel);
        this.myConditionsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setBackground(UIUtil.getListBackground((boolean)selected));
                TraceProjectSettings.EventFilterConditionState condition = (TraceProjectSettings.EventFilterConditionState)value;
                this.append(String.format(TraceBundle.message("settings.eventFilters.conditionListPattern", new Object[0]), condition.getTypeDisplayName(), ""));
                this.append(condition.getValue(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        });
        this.myConditionsList.getEmptyText().setText(TraceBundle.message("settings.eventFilters.noCond", new Object[0]));
        conditionsListPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myConditionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EventFilterPanel.this.addCondition();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EventFilterPanel.this.removeCondition();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EventFilterPanel.this.editCondition();
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myNameField = new JBTextField(filter.getName());
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                nameChangeListener.consume((Object)EventFilterPanel.this.myNameField.getText());
            }
        });
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel formPanel = builder.addLabeledComponent(TraceBundle.message("settings.eventFilters.filterName", new Object[0]), (JComponent)this.myNameField).getPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = builder.getLineCount() + 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        formPanel.add((Component)conditionsListPanel, c);
        this.add(formPanel);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                EventFilterPanel.this.editCondition();
                return true;
            }
        }.installOn((Component)this.myConditionsList);
    }

    public void updateNameLabel() {
        this.myNameField.setText(this.myFilter.getName());
    }

    private void editCondition() {
        TraceProjectSettings.EventFilterConditionState originalCondition = (TraceProjectSettings.EventFilterConditionState)this.myConditionsList.getSelectedValue();
        TraceProjectSettings.EventFilterConditionState newCondition = (TraceProjectSettings.EventFilterConditionState)originalCondition.clone();
        EventFilterConditionDialog dlg = new EventFilterConditionDialog(this, newCondition);
        if (dlg.showAndGet()) {
            originalCondition.setType(newCondition.getType());
            originalCondition.setValue(newCondition.getValue());
            this.myConditionListModel.update(this.myConditionsList.getSelectedIndex());
        }
    }

    private void removeCondition() {
        this.myFilter.removeEventFilterCondition((TraceProjectSettings.EventFilterConditionState)this.myConditionsList.getSelectedValue());
        ListUtil.removeSelectedItems((JList)this.myConditionsList);
        this.myConditionsList.repaint();
    }

    private void addCondition() {
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        EventFilterConditionDialog dlg = new EventFilterConditionDialog(this, condition);
        if (dlg.showAndGet()) {
            ((DefaultListModel)this.myConditionsList.getModel()).addElement(condition);
            this.myFilter.addEventFilterCondition(condition);
        }
    }

    private static class MyConditionListModel
    extends DefaultListModel {
        private MyConditionListModel() {
        }

        public void update(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }
}

