/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SpyJsConfiguration", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/spy-js.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class TraceProjectSettings
implements PersistentStateComponent<TraceSettingsState> {
    private TraceSettingsState myState = new TraceSettingsState();

    @NotNull
    public static TraceProjectSettings getInstance(Project project) {
        TraceProjectSettings traceProjectSettings = (TraceProjectSettings)ServiceManager.getService((Project)project, TraceProjectSettings.class);
        if (traceProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/settings/TraceProjectSettings", "getInstance"));
        }
        return traceProjectSettings;
    }

    @NotNull
    public TraceSettingsState getState() {
        TraceSettingsState traceSettingsState = this.myState;
        if (traceSettingsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/settings/TraceProjectSettings", "getState"));
        }
        return traceSettingsState;
    }

    public void loadState(TraceSettingsState state) {
        this.myState = state;
    }

    @Tag(value="event-filter-condition")
    public static class EventFilterConditionState
    implements Cloneable {
        private String myValue = "";
        private String myType = "event";
        private boolean myIsInverted = false;
        public static final String EVENT_TYPE = "event";
        public static final String FILE_TYPE = "file";
        private static final Map<String, String> TYPE_NAMES = new HashMap<String, String>();
        private boolean isMyPatternCompiled;
        private Pattern myPattern;

        @Attribute(value="value")
        public String getValue() {
            return this.myValue;
        }

        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState", "setValue"));
            }
            this.myValue = value;
            this.myIsInverted = this.myValue.startsWith("!");
            this.isMyPatternCompiled = false;
        }

        @Attribute(value="type")
        public String getType() {
            return this.myType;
        }

        public void setType(@NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState", "setType"));
            }
            this.myType = type;
        }

        @NotNull
        public String getTypeDisplayName() {
            String string = TYPE_NAMES.get(this.getType());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState", "getTypeDisplayName"));
            }
            return string;
        }

        @NotNull
        public static String getTypeDisplayName(String type) {
            String string = TYPE_NAMES.get(type);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState", "getTypeDisplayName"));
            }
            return string;
        }

        @NotNull
        public static String[] getTypes() {
            Set<String> types = TYPE_NAMES.keySet();
            String[] stringArray = types.toArray(new String[types.size()]);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState", "getTypes"));
            }
            return stringArray;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventFilterConditionState state = (EventFilterConditionState)o;
            if (!this.myType.equals(state.myType)) {
                return false;
            }
            return this.myValue.equals(state.myValue);
        }

        public int hashCode() {
            int result = this.myValue.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }

        public Object clone() {
            EventFilterConditionState condition = new EventFilterConditionState();
            condition.setType(this.getType());
            condition.setValue(this.getValue());
            return condition;
        }

        private boolean matches(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterConditionState", "matches"));
            }
            Pattern pattern = this.getPattern();
            if (pattern == null) {
                return false;
            }
            Matcher matcher = pattern.matcher(value);
            boolean matches = matcher.matches();
            return this.myIsInverted ? !matches : matches;
        }

        private Pattern getPattern() {
            if (this.isMyPatternCompiled) {
                return this.myPattern;
            }
            String regExString = EventFilterConditionState.convertGlobToRegEx(this.myValue);
            if (this.myIsInverted) {
                regExString = regExString.substring(1);
            }
            try {
                this.myPattern = Pattern.compile(regExString, 2);
            }
            catch (PatternSyntaxException e) {
                this.myPattern = null;
            }
            this.isMyPatternCompiled = true;
            return this.myPattern;
        }

        private static String convertGlobToRegEx(String glob) {
            glob = glob.trim();
            int strLen = glob.length();
            StringBuilder sb = new StringBuilder(strLen);
            boolean escaping = false;
            int inCurlyBraces = 0;
            block9: for (char currentChar : glob.toCharArray()) {
                switch (currentChar) {
                    case '*': {
                        if (escaping) {
                            sb.append("\\*");
                        } else {
                            sb.append(".*");
                        }
                        escaping = false;
                        continue block9;
                    }
                    case '?': {
                        if (escaping) {
                            sb.append("\\?");
                        } else {
                            sb.append('.');
                        }
                        escaping = false;
                        continue block9;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        sb.append('\\');
                        sb.append(currentChar);
                        escaping = false;
                        continue block9;
                    }
                    case '\\': {
                        if (escaping) {
                            sb.append("\\\\");
                            escaping = false;
                            continue block9;
                        }
                        escaping = true;
                        continue block9;
                    }
                    case '{': {
                        if (escaping) {
                            sb.append("\\{");
                        } else {
                            sb.append('(');
                            ++inCurlyBraces;
                        }
                        escaping = false;
                        continue block9;
                    }
                    case '}': {
                        if (inCurlyBraces > 0 && !escaping) {
                            sb.append(')');
                            --inCurlyBraces;
                        } else if (escaping) {
                            sb.append("\\}");
                        } else {
                            sb.append("}");
                        }
                        escaping = false;
                        continue block9;
                    }
                    case ',': {
                        if (inCurlyBraces > 0 && !escaping) {
                            sb.append('|');
                            continue block9;
                        }
                        if (escaping) {
                            sb.append("\\,");
                            continue block9;
                        }
                        sb.append(",");
                        continue block9;
                    }
                    default: {
                        escaping = false;
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }

        static {
            TYPE_NAMES.put(EVENT_TYPE, TraceBundle.message("settings.eventFilters.conditionType.event", new Object[0]));
            TYPE_NAMES.put(FILE_TYPE, TraceBundle.message("settings.eventFilters.conditionType.file", new Object[0]));
        }
    }

    @Tag(value="event-filter")
    public static class EventFilterState
    implements Cloneable {
        public static final EventFilterState NULL_FILTER = new EventFilterState(TraceBundle.message("console.trace.toolbar.filterEvents.allName", new Object[0]), true){

            @Override
            public boolean matchesEventName(@NotNull String eventName) {
                if (eventName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventName", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$1", "matchesEventName"));
                }
                return false;
            }

            @Override
            public boolean matchesFileName(@NotNull String fileName) {
                if (fileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$1", "matchesFileName"));
                }
                return false;
            }

            @Override
            public boolean matchesAllFileNames(@NotNull String[] fileNames) {
                if (fileNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$1", "matchesAllFileNames"));
                }
                return false;
            }
        };
        public static final EventFilterState ALL_FILTER = new EventFilterState(TraceBundle.message("console.trace.toolbar.filterEvents.nothingName", new Object[0]), true){

            @Override
            public boolean matchesEventName(@NotNull String eventName) {
                if (eventName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventName", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$2", "matchesEventName"));
                }
                return true;
            }

            @Override
            public boolean matchesFileName(@NotNull String fileName) {
                if (fileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$2", "matchesFileName"));
                }
                return false;
            }

            @Override
            public boolean matchesAllFileNames(@NotNull String[] fileNames) {
                if (fileNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState$2", "matchesAllFileNames"));
                }
                return false;
            }
        };
        private String myName;
        private List<EventFilterConditionState> myEventFilterConditions;
        private boolean myIsActive;

        public static boolean isAllOrNothingFilter(EventFilterState filter) {
            return NULL_FILTER == filter || ALL_FILTER == filter;
        }

        public EventFilterState() {
            this.myName = "";
            this.myEventFilterConditions = new SmartList();
            this.myIsActive = true;
        }

        public EventFilterState(@NotNull String name, boolean isActive) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "<init>"));
            }
            this.myName = "";
            this.myEventFilterConditions = new SmartList();
            this.myIsActive = true;
            this.myName = name;
            this.myIsActive = isActive;
        }

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @Attribute(value="active")
        public boolean isActive() {
            return this.myIsActive;
        }

        public void setActive(boolean isActive) {
            this.myIsActive = isActive;
        }

        @AbstractCollection(surroundWithTag=false)
        @Tag(value="event-filter-conditions")
        public List<EventFilterConditionState> getEventFilterConditions() {
            return this.myEventFilterConditions;
        }

        public void setEventFilterConditions(List<EventFilterConditionState> eventFilterConditions) {
            this.myEventFilterConditions = eventFilterConditions;
        }

        public boolean isEmpty() {
            return this.myEventFilterConditions.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventFilterState state = (EventFilterState)o;
            if (this.myIsActive != state.myIsActive) {
                return false;
            }
            if (!this.myEventFilterConditions.equals(state.myEventFilterConditions)) {
                return false;
            }
            return this.myName.equals(state.myName);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myEventFilterConditions.hashCode();
            result = 31 * result + (this.myIsActive ? 1 : 0);
            return result;
        }

        public Object clone() {
            EventFilterState filter = new EventFilterState(this.getName(), this.isActive());
            filter.setEventFilterConditions(new ArrayList<EventFilterConditionState>(ContainerUtil.map(this.getEventFilterConditions(), (Function)new Function<EventFilterConditionState, EventFilterConditionState>(){

                public EventFilterConditionState fun(EventFilterConditionState cond) {
                    return (EventFilterConditionState)cond.clone();
                }
            })));
            return filter;
        }

        public void addEventFilterCondition(@NotNull EventFilterConditionState condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "addEventFilterCondition"));
            }
            this.myEventFilterConditions.add(condition);
        }

        public void removeEventFilterCondition(EventFilterConditionState condition) {
            this.myEventFilterConditions.remove(condition);
        }

        public boolean matchesEventName(@NotNull String eventName) {
            if (eventName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventName", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "matchesEventName"));
            }
            return this.getEventNamePredicate().apply((Object)eventName);
        }

        public boolean matchesFileName(@NotNull String fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "matchesFileName"));
            }
            return this.getFileNamePredicate().apply((Object)fileName);
        }

        public boolean matchesAllFileNames(@NotNull String[] fileNames) {
            if (fileNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "matchesAllFileNames"));
            }
            return !ContainerUtil.exists((Object[])fileNames, (Condition)new Condition<String>(){

                public boolean value(String file) {
                    return !EventFilterState.this.matchesFileName(file);
                }
            });
        }

        private Predicate<String> getEventNamePredicate() {
            return this.getTypePredicate("event");
        }

        private Predicate<String> getFileNamePredicate() {
            return this.getTypePredicate("file");
        }

        private Predicate<String> getTypePredicate(final @NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "getTypePredicate"));
            }
            final List eventNameConditions = ContainerUtil.filter(this.getEventFilterConditions(), (Condition)new Condition<EventFilterConditionState>(){

                public boolean value(EventFilterConditionState state) {
                    return state.getType().equals(type);
                }
            });
            return new Predicate<String>(){

                public boolean apply(final @Nullable String input) {
                    return ContainerUtil.exists((Iterable)eventNameConditions, (Condition)new Condition<EventFilterConditionState>(){

                        public boolean value(EventFilterConditionState state) {
                            assert (input != null);
                            return state.matches(input);
                        }
                    });
                }
            };
        }

        public Collection<String> getEventNameRegularExpressions() {
            return this.getRegularExpressions("event");
        }

        public Collection<String> getFileNameRegularExpressions() {
            return this.getRegularExpressions("file");
        }

        private Collection<String> getRegularExpressions(final @NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/trace/settings/TraceProjectSettings$EventFilterState", "getRegularExpressions"));
            }
            return ContainerUtil.map((Collection)ContainerUtil.filter(this.getEventFilterConditions(), (Condition)new Condition<EventFilterConditionState>(){

                public boolean value(EventFilterConditionState state) {
                    return state.getType().equals(type);
                }
            }), (Function)new Function<EventFilterConditionState, String>(){

                public String fun(EventFilterConditionState condition) {
                    return EventFilterConditionState.convertGlobToRegEx(condition.getValue());
                }
            });
        }

        static {
            EventFilterConditionState condition = new EventFilterConditionState();
            condition.setType("event");
            condition.setValue("!#");
            ALL_FILTER.addEventFilterCondition(condition);
        }
    }

    public static class TraceSettingsState
    implements Cloneable {
        private List<EventFilterState> myEventFilters = new SmartList();

        @AbstractCollection(surroundWithTag=false)
        @Tag(value="event-filters")
        public List<EventFilterState> getEventFilters() {
            return this.myEventFilters;
        }

        public void setEventFilters(List<EventFilterState> eventFilters) {
            this.myEventFilters = eventFilters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceSettingsState state = (TraceSettingsState)o;
            return this.myEventFilters.equals(state.myEventFilters);
        }

        public int hashCode() {
            return this.myEventFilters.hashCode();
        }

        public Object clone() {
            TraceSettingsState state = new TraceSettingsState();
            state.setEventFilters(new ArrayList<EventFilterState>(ContainerUtil.map(this.getEventFilters(), (Function)new Function<EventFilterState, EventFilterState>(){

                public EventFilterState fun(EventFilterState filter) {
                    return (EventFilterState)filter.clone();
                }
            })));
            return state;
        }

        public void addEventFilter(EventFilterState filter) {
            this.myEventFilters.add(filter);
        }

        public void removeEventFilter(EventFilterState filter) {
            this.myEventFilters.remove(filter);
        }

        public EventFilterState findEventFilterByName(final String name) {
            if (name == null) {
                return null;
            }
            return (EventFilterState)ContainerUtil.find(this.getEventFilters(), (Condition)new Condition<EventFilterState>(){

                public boolean value(EventFilterState state) {
                    return state.getName().equals(name);
                }
            });
        }

        public EventFilterState findEventFilterByOnlyCondition(final String value) {
            if (value == null) {
                return null;
            }
            return (EventFilterState)ContainerUtil.find(this.getEventFilters(), (Condition)new Condition<EventFilterState>(){

                public boolean value(EventFilterState state) {
                    if (!state.isActive()) {
                        return false;
                    }
                    List<EventFilterConditionState> conditions = state.getEventFilterConditions();
                    return conditions.size() == 1 && value.equals(conditions.get(0).getValue());
                }
            });
        }
    }
}

