/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMBundleArtifactType;
import com.intellij.dmserver.artifacts.DMConfigArtifactType;
import com.intellij.dmserver.artifacts.DMParArtifactType;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.dmserver.artifacts.WithModulePackagingElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WithModuleArtifactUtil {
    public static Artifact findDmBundleArtifactFor(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/WithModuleArtifactUtil", "findDmBundleArtifactFor"));
        }
        Project project = module.getProject();
        ArtifactManager manager = ArtifactManager.getInstance((Project)project);
        ArrayList scope = new ArrayList();
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMBundleArtifactType.getInstance()));
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMParArtifactType.getInstance()));
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMPlanArtifactType.getInstance()));
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMConfigArtifactType.getInstance()));
        for (Artifact nextArtifact : scope) {
            Module nextModule = WithModuleArtifactUtil.findModuleFor(project, nextArtifact);
            if (!module.equals(nextModule)) continue;
            return nextArtifact;
        }
        return null;
    }

    @NotNull
    public static List<Artifact> findWithModuleArtifactsFor(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/WithModuleArtifactUtil", "findWithModuleArtifactsFor"));
        }
        Project project = module.getProject();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact next : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            Module nextModule = WithModuleArtifactUtil.findModuleFor(project, next);
            if (!module.equals(nextModule)) continue;
            result.add(next);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/WithModuleArtifactUtil", "findWithModuleArtifactsFor"));
        }
        return arrayList;
    }

    @NotNull
    public static List<Artifact> findWithModuleArtifactsFor(Project project, @NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/dmserver/artifacts/WithModuleArtifactUtil", "findWithModuleArtifactsFor"));
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact next : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            String nextModuleName = WithModuleArtifactUtil.findModuleNameFor(project, next);
            if (!moduleName.equals(nextModuleName)) continue;
            result.add(next);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/WithModuleArtifactUtil", "findWithModuleArtifactsFor"));
        }
        return arrayList;
    }

    @Nullable
    private static String findModuleNameFor(Project project, Artifact artifact) {
        if (!(artifact.getArtifactType() instanceof DMArtifactTypeBase)) {
            return null;
        }
        DMArtifactTypeBase artifactType = (DMArtifactTypeBase)artifact.getArtifactType();
        final ArrayList moduleNames = new ArrayList();
        Processor<WithModulePackagingElement> processor = new Processor<WithModulePackagingElement>(){

            public boolean process(WithModulePackagingElement element) {
                String moduleName = element.getModuleName();
                if (moduleName != null) {
                    moduleNames.add(moduleName);
                }
                return false;
            }
        };
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        ArtifactUtil.processPackagingElements((Artifact)artifact, artifactType.getModulePackagingElementType(), (Processor)processor, (PackagingElementResolvingContext)context, (boolean)false);
        if (moduleNames.isEmpty()) {
            return null;
        }
        String theOneName = (String)moduleNames.get(0);
        return theOneName;
    }

    @Nullable
    public static Module findModuleFor(Project project, Artifact artifact) {
        String moduleName = WithModuleArtifactUtil.findModuleNameFor(project, artifact);
        return moduleName == null ? null : ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
    }
}

