/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.dmserver.artifacts.ManifestUpdater;
import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.editor.ChooseImportedUnitsDialog;
import com.intellij.dmserver.editor.ExportedUnit;
import com.intellij.dmserver.editor.ImportedUnit;
import com.intellij.dmserver.editor.ImportedUnitAttributesDialog;
import com.intellij.dmserver.editor.ImportedUnitImpl;
import com.intellij.dmserver.editor.UnitsCollector;
import com.intellij.dmserver.editor.wrapper.ClauseWrapper;
import com.intellij.dmserver.editor.wrapper.HeaderWrapper;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.VersionUtils;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.ManifestFile;

public abstract class ImportedUnitsPanel {
    private static final Comparator<ImportedUnit> UNITS_COMPARATOR = new Comparator<ImportedUnit>(){

        @Override
        public int compare(ImportedUnit o1, ImportedUnit o2) {
            int namesDiff = o1.getSymbolicName().compareTo(o2.getSymbolicName());
            if (namesDiff != 0) {
                return namesDiff;
            }
            return o1.getVersionRange().toString().compareTo(o2.getVersionRange().toString());
        }
    };
    private JPanel myMainPanel;
    private JList myUnitsList;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JLabel myTitleLabel;
    private JButton myAttributesButton;
    private Project myProject;
    private ManifestFile myManifestFile;
    private ManifestUpdater myManifestUpdater;
    private SortedListModel<ImportedUnit> myUnitsListModel;
    private boolean myInSave = false;

    public ImportedUnitsPanel() {
        this.$$$setupUI$$$();
        this.myUnitsListModel = SortedListModel.create(UNITS_COMPARATOR);
        this.myUnitsList.setModel(this.myUnitsListModel);
        this.myUnitsList.setCellRenderer(new ImportedUnitRenderer());
        this.myUnitsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImportedUnitsPanel.this.updateEnablement();
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportedUnitsPanel.this.onAdd();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportedUnitsPanel.this.onRemove();
            }
        });
        this.myAttributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportedUnitsPanel.this.onAttributes();
            }
        });
    }

    private void updateEnablement() {
        boolean someUnitsSelected = this.myUnitsList.getSelectedIndex() >= 0;
        this.myRemoveButton.setEnabled(someUnitsSelected);
        this.myAttributesButton.setEnabled(someUnitsSelected);
    }

    public void init(@NotNull Project project, @NotNull ManifestFile manifestFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/editor/ImportedUnitsPanel", "init"));
        }
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/dmserver/editor/ImportedUnitsPanel", "init"));
        }
        this.myProject = project;
        this.myManifestFile = manifestFile;
        this.myManifestUpdater = new ManifestUpdater(manifestFile);
        this.myTitleLabel.setText(this.getListTitle());
        this.load();
        this.updateEnablement();
    }

    private Project getProject() {
        return this.myProject;
    }

    public void notifyFileChanged() {
        if (this.myInSave) {
            return;
        }
        this.load();
    }

    private void load() {
        this.myUnitsListModel.clear();
        HeaderWrapper importHeaderWrapper = new HeaderWrapper((PsiFile)this.myManifestFile, this.getHeaderName());
        for (ClauseWrapper clause : importHeaderWrapper.getClauses()) {
            this.myUnitsListModel.add((Object)new ImportedUnitImpl(clause.getName(), VersionUtils.loadVersionRange(clause.getAttributeValue("version")), "optional".equals(clause.getDirectiveValue("resolution"))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        this.myInSave = true;
        try {
            StringBuilder headerValue = new StringBuilder();
            for (ImportedUnit existingUnit : this.myUnitsListModel.getItems()) {
                if (headerValue.length() > 0) {
                    headerValue.append(",\n ");
                }
                headerValue.append(existingUnit.getSymbolicName());
                if (!VersionUtils.emptyRange.equals((Object)existingUnit.getVersionRange())) {
                    headerValue.append(";");
                    headerValue.append("version");
                    headerValue.append("=\"");
                    headerValue.append(existingUnit.getVersionRange().toString());
                    headerValue.append("\"");
                }
                if (!existingUnit.isOptional()) continue;
                headerValue.append(";");
                headerValue.append("resolution");
                headerValue.append(":=");
                headerValue.append("optional");
            }
            this.myManifestUpdater.updateHeader(this.getHeaderName(), headerValue.toString(), false);
        }
        finally {
            this.myInSave = false;
        }
    }

    private void onAdd() {
        final HashMap nameVersionKey2unit = new HashMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                HashSet<String> existingUnitSymbolicNames = new HashSet<String>();
                for (ImportedUnit existingUnit : ImportedUnitsPanel.this.myUnitsListModel.getItems()) {
                    existingUnitSymbolicNames.add(existingUnit.getSymbolicName());
                }
                existingUnitSymbolicNames.addAll(ImportedUnitsPanel.this.getOwnSymbolicNames(ImportedUnitsPanel.this.myManifestFile));
                AvailableBundlesProvider provider = AvailableBundlesProvider.getInstance(ImportedUnitsPanel.this.getProject());
                provider.resetAll();
                UnitsCollector unitsCollector = ImportedUnitsPanel.this.getUnitsCollector(provider);
                for (ExportedUnit availableUnit : unitsCollector.getAvailableUnits()) {
                    if (existingUnitSymbolicNames.contains(availableUnit.getSymbolicName())) continue;
                    nameVersionKey2unit.put(availableUnit.getSymbolicName() + "###" + availableUnit.getVersion(), availableUnit);
                }
            }
        }, this.getCollectingStatus(), true, this.getProject())) {
            return;
        }
        ChooseImportedUnitsDialog addDialog = new ChooseImportedUnitsDialog(this.getProject(), new ArrayList(nameVersionKey2unit.values()), this.getAddDialogTitle());
        if (!addDialog.showAndGet()) {
            return;
        }
        for (ExportedUnit addedUnit : addDialog.getChosenElements()) {
            this.myUnitsListModel.add((Object)new ImportedUnitImpl(addedUnit.getSymbolicName(), VersionUtils.version2range(addedUnit.getVersion()), false));
        }
        this.save();
    }

    private void onRemove() {
        for (Object selectedUnitElement : this.myUnitsList.getSelectedValues()) {
            this.myUnitsListModel.remove((Object)((ImportedUnit)selectedUnitElement));
        }
        this.myUnitsList.setSelectedIndices(new int[0]);
        this.save();
    }

    private void onAttributes() {
        ArrayList<ImportedUnit> selectedUnits = new ArrayList<ImportedUnit>();
        for (Object selectedUnitElement : this.myUnitsList.getSelectedValues()) {
            selectedUnits.add((ImportedUnit)selectedUnitElement);
        }
        ImportedUnitAttributesDialog attributesDialog = new ImportedUnitAttributesDialog(this.getProject(), selectedUnits);
        if (!attributesDialog.showAndGet()) {
            return;
        }
        this.save();
    }

    @Nls
    protected abstract String getListTitle();

    @NonNls
    protected abstract String getHeaderName();

    @Nls
    protected abstract String getAddDialogTitle();

    @Nls
    protected abstract String getCollectingStatus();

    protected abstract UnitsCollector getUnitsCollector(AvailableBundlesProvider var1);

    protected abstract Collection<String> getOwnSymbolicNames(ManifestFile var1);

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JBList jBList = new JBList();
        this.myUnitsList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.ImportedUnitsPanel.add"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.ImportedUnitsPanel.remove"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAttributesButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.ImportedUnitsPanel.attributes"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ImportedUnitRenderer
    extends DefaultListCellRenderer {
        private ImportedUnitRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ImportedUnit importedUnit = (ImportedUnit)value;
            component.setText(DmServerBundle.message(importedUnit.isOptional() ? "ImportedUnitsPanel.list.item.optional" : "ImportedUnitsPanel.list.item", importedUnit.getSymbolicName(), importedUnit.getVersionRange().toString()));
            return component;
        }
    }
}

