/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor.wrapper;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osmorc.manifest.lang.psi.AssignmentExpression;

public class AttributeWrapper {
    private final String myName;
    private final String myValue;

    public AttributeWrapper(String attributeName, String attributeValue) {
        this.myName = attributeName;
        this.myValue = attributeValue;
    }

    @Nullable
    public static AttributeWrapper create(AssignmentExpression attribute) {
        HeaderValuePart nameValuePart = (HeaderValuePart)PsiTreeUtil.getChildOfType((PsiElement)attribute, HeaderValuePart.class);
        if (nameValuePart == null) {
            return null;
        }
        HeaderValuePart valueValuePart = (HeaderValuePart)PsiTreeUtil.getNextSiblingOfType((PsiElement)nameValuePart, HeaderValuePart.class);
        return new AttributeWrapper(nameValuePart.getUnwrappedText(), valueValuePart == null ? null : AttributeWrapper.trimValue(valueValuePart.getUnwrappedText()));
    }

    private static String trimValue(@NotNull String attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/dmserver/editor/wrapper/AttributeWrapper", "trimValue"));
        }
        if (attributeValue.startsWith("\"")) {
            attributeValue = attributeValue.substring(1);
        }
        if (attributeValue.endsWith("\"")) {
            attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
        }
        return attributeValue;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }
}

