/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    public static JSONObject loadConfig(VirtualFile file) throws IOException {
        InputStream is = null;
        try {
            JSONObject jsonObject;
            is = file.getInputStream();
            JSONObject jSONObject = jsonObject = new JSONObject(JsonUtil.convertStreamToString(is));
            return jSONObject;
        }
        catch (IOException e) {
            throw new IOException(".config file has unknown format", e);
        }
        catch (JSONException e) {
            throw new IOException(".config file has unknown format", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void saveConfig(VirtualFile file, JSONObject config) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(file.getOutputStream(JsonUtil.class));
            config.write((Writer)osw);
            osw.close();
        }
        catch (IOException e) {
            throw new IOException(".config file has unknown format", e);
        }
        catch (JSONException e) {
            throw new IOException(".config file has unknown format", e);
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }
}

