declare module v8debug {
  var UNDEFINED_TYPE: string;
  var NULL_TYPE: string;
  var BOOLEAN_TYPE: string;
  var NUMBER_TYPE: string;
  var STRING_TYPE: string;
  var OBJECT_TYPE: string;
  var FUNCTION_TYPE: string;
  var REGEXP_TYPE: string;
  var ERROR_TYPE: string;
  var FRAME_TYPE: string;

  var mirror_cache_: Array<ValueMirror>
  var next_handle_: number

  var Debug: Debug

  class PropertyKind {
    static Named: number;
    static Indexed: number;
  }

  class ScopeType {
    static Global: number;
    static Local: number;
    static With: number;
    static Closure: number;
    static Catch: number;
    static Block: number;
  }

  function MakeMirror(value: any, transient: boolean): any;

  class Mirror {
    constructor(type: string);

    type(): string;

    handle(): number;

    toText(): string;

    isArray(): boolean;

    isFunction(): boolean;

    isDate(): boolean;

    isRegExp(): boolean;

    isUndefined(): boolean;

    isNull(): boolean;
  }

  class ValueMirror extends Mirror {
    constructor(type: string, value: any, transient: boolean);

    value(): any;
  }

  class ObjectMirror extends ValueMirror {
    constructor(value: any, type: string, transient: boolean);

    className(): string;

    property(name: string): PropertyMirror;

    propertyNames(kind: number, limit: number): Array<string>;

    properties(kind: number, limit: number): Array<ObjectMirror>;

    constructorFunction(): FunctionMirror;

    protoObject(): ValueMirror;

    value_: any;
  }

  interface SourceLocation {
    line?:number;
    column?:number;
  }

  interface ScopeHost {
    scopeCount():number;

    scope(index: number):ScopeMirror;

    sourceLocation():SourceLocation;
  }

  class FrameMirror extends Mirror implements ScopeHost {
    // recently added, old V8 version doesn't have this method
    //details():FrameDetails;

    details_: FrameDetails;

    index(): number;

    scopeCount(): number;

    scope(index: number): ScopeMirror;

    sourceLocation(): SourceLocation;

    isDebuggerFrame(): boolean;

    isAtReturn(): boolean;

    isConstructCall(): boolean;

    func(): FunctionMirror;

    receiver(): Mirror;

    //script(): ScriptMirror

    evaluate(expression: string, disableBreak: boolean, additionalContext: any): ValueMirror;

    allScopes(opt_ignore_nested_scopes?: Boolean): Array<ScopeMirror>;
  }

  class FrameDetails {
    constructor(breakId: number, index: number);

    receiver(): any;

    func(): any;

    scopeCount(): number;
  }

  class ScopeMirror extends Mirror {
    scopeType(): number;

    scopeObject(): any;

    details_: ScopeDetails;
  }

  class ScopeDetails {
    constructor(frameMirror: FrameMirror, functionMirror: FunctionMirror, scopeIndex: number);

    object(): any;

    type(): number;
  }

  class FunctionMirror extends ObjectMirror implements ScopeHost {
    constructor(value: any);

    name(): string;

    inferredName(): string;

    // nullable
    script(): ScriptMirror;

    source(): string;

    scopeCount(): number;

    scope(index: number): ScopeMirror;

    sourceLocation(): SourceLocation;
  }

  class ScriptMirror extends Mirror {
    id(): number

    name(): string

    source(): string

    context(): any

    scriptType(): number

    lineOffset(): number
    columnOffset(): number
    lineCount(): number

    value(): Script
  }

  class BreakPoint {
    isTriggered(state: ExecutionState): boolean

    super$isTriggered(state: ExecutionState): boolean

    active(): boolean

    condition(): string
  }

  class StringMirror extends ValueMirror {
    constructor(value: string);

    length(): number;

    value(): string;
  }

  class ArrayMirror extends ObjectMirror {
    constructor(value: Array<any>);

    length(): number;
  }

  class DateMirror extends ObjectMirror {
    constructor(value: Date);
  }

  class RegExpMirror extends ObjectMirror {
    constructor(value: RegExp);
  }

  class PropertyMirror extends Mirror {
    name(): string;

    value_: any;
    getter_: Function;
    setter_: Function;
  }

  class JSONProtocolSerializer {
    serialize_(mirror: Mirror, reference: boolean, details: boolean): any;
  }

  class ProtocolMessage {
    failed(message: string, details?: any): void;

    toJSONProtocol(): string;

    request_seq: number;
  }

  interface Request {
    seq:number;
    command:string;
    arguments:any;
  }

  class ExecutionState {
    frameCount(): number

    frame(index: number): FrameMirror

    break_id: number

    evaluateGlobal(expression: string, disableBreak: boolean, additionalContext: any): ValueMirror
  }

  class DebugCommandProcessor {
    running_: boolean
    exec_state_: ExecutionState

    resolveScopeHolder_(): Mirror

    resolveFrameFromScopeDescription_(request: any): FrameMirror

    createResponse(request?: Request): ProtocolMessage

    processDebugJSONRequest(jsonRequest: string): string

    // fake, ability to set
    super$processDebugJSONRequest(jsonRequest: string): string

    static resolveValue_(valueDescription: any): any
  }

  class BreakEvent {
    toJSONProtocol(): string

    // fake, ability to set
    super$toJSONProtocol(): string

    breakPointsHit(): any[]

    // nodejs v5
    frame_: FrameMirror

    // nodejs v4
    exec_state_: ExecutionState
  }

  class CompileEvent {
    toJSONProtocol(): string

    // fake, ability to set
    super$toJSONProtocol(): string

    type_: number

    script(): ScriptMirror

    eventType(): number
  }

  interface Debug {
    scripts(): Array<Script>
  }

  interface Script {
    id: number

    source: string

    type: number

    name: string

    source_url: string

    line_offset: number
    column_offset: number

    line_ends: any[]

    source_mapping_url: string
  }
}