package com.intellij.sql.psi;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.ScriptModel;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.script.SqlReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Gregory.Shrago
 */
public abstract class SqlPsiFacade {

  private static final NotNullLazyKey<SqlPsiFacade, Project> INSTANCE_KEY = ServiceManager.createLazyKey(SqlPsiFacade.class);

  @NotNull
  public static SqlPsiFacade getInstance(Project project) {
    return INSTANCE_KEY.getValue(project);
  }

  @NotNull
  public abstract ScriptModel<?> createScriptModel(@NotNull PsiFile file);

  @NotNull
  public abstract SqlReader createSqlReader();

  @NotNull
  public abstract PsiCodeFragment createTableReferenceFragment(@NotNull Language dialect,
                                                               @Nullable DbDataSource dataSourceElement,
                                                               @Nullable DbElement schemaElement,
                                                               @NotNull String text);

  @NotNull
  public abstract PsiCodeFragment createTypeElementFragment(@NotNull Language dialect,
                                                            @Nullable DbDataSource dataSourceElement,
                                                            @NotNull String text);

  @NotNull
  public abstract PsiCodeFragment createExpressionFragment(@NotNull Language dialect,
                                                           @Nullable DbDataSource dataSourceElement,
                                                           @NotNull String text);

  @NotNull
  public abstract PsiCodeFragment createExpressionFragment(@NotNull Language dialect,
                                                           @Nullable DbDataSource dataSourceElement,
                                                           @NotNull String text,
                                                           @NotNull String context);

  @NotNull
  public abstract SqlLanguageDialect getDefaultDialect();
}