package com.intellij.sql.psi.impl;

import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/**
 * @author Gregory.Shrago
 */
public class SqlTokenType extends IElementType {

  public SqlTokenType(@NotNull @NonNls String debugName) {
    super(debugName, SqlLanguage.getInstance());
  }

  public SqlTokenType(@NotNull @NonNls String debugName, SqlLanguageDialect dialect) {
    super(debugName, dialect);
  }

  public static class Synthetic extends SqlTokenType {

    public final static NotNullFunction<String, Synthetic> FACTORY = new NotNullFunction<String, Synthetic>() {
      @NotNull
      @Override
      public Synthetic fun(String name) {
        return new Synthetic(name);
      }
    };

    public Synthetic(@NotNull @NonNls String debugName) {
      super(debugName);
    }
  }
}
