/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.contexts.model;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
 * Records visited models to avoid recursive processing.
 *
 * @since 14.1
 */
public class VisitedModelsDelegateProcessor implements Processor<SpringBeanPointer> {

  private final Set<CommonSpringModel> visited = ContainerUtil.newHashSet();

  private final Processor<SpringBeanPointer> myProcessor;

  public VisitedModelsDelegateProcessor(@NotNull Processor<SpringBeanPointer> processor) {
    myProcessor = processor;
  }

  @Override
  public boolean process(SpringBeanPointer pointer) {
    return myProcessor.process(pointer);
  }

  public void addVisited(@NotNull CommonSpringModel model) {
    visited.add(model);
  }

  public boolean hasBeenVisited(@NotNull CommonSpringModel model) {
    return visited.contains(model);
  }
}
