/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.el.contextProviders;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * SpEL context variables completion/resolving.
 *
 * @since 15
 */
public abstract class SpringElContextsExtension {

  private static final ExtensionPointName<SpringElContextsExtension> EP_NAME =
    new ExtensionPointName<SpringElContextsExtension>("com.intellij.spring.el.contexts");

  public static SpringElContextsExtension[] getProviders() {
    return Extensions.getExtensions(EP_NAME);
  }

  @NotNull
  public abstract Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement);

  @Nullable
  public PsiVariable findContextVariable(@NotNull PsiElement contextElement, @NotNull final String hint) {
    return ContainerUtil.find(getContextVariables(contextElement), new Condition<PsiVariable>() {
      @Override
      public boolean value(PsiVariable variable) {
        return hint.equals(variable.getName());
      }
    });
  }
}
