/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.util.xml.ConvertContext;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

public class LookupMethodBeanConverter extends SpringBeanResolveConverter {

  @NotNull
  public List<PsiClassType> getRequiredClasses(final ConvertContext context) {
    final LookupMethod lookupMethod = (LookupMethod)context.getInvocationElement().getParent();
    assert lookupMethod != null;
    final PsiMethod psiMethod = lookupMethod.getName().getValue();
    if (psiMethod != null) {
      final PsiType returnType = psiMethod.getReturnType();
      if (returnType instanceof PsiClassType) {
        return Collections.singletonList((PsiClassType)returnType);
      }
    }
    return Collections.emptyList();
  }
}