/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.jam;

import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamPsiMethodSpringBean extends JamPsiMemberSpringBean<PsiMethod> {

  @NotNull
  @JamPsiConnector
  public abstract PsiMethod getPsiElement();

  @Override
  @JamPsiValidity
  public abstract boolean isValid();

  @Nullable
  public String getBeanName() {
    return getPsiElement().getName();
  }

  @Nullable
  public PsiClass getBeanClass() {
    final PsiMethod method = getPsiElement();
    final PsiType returnType = method.getReturnType();
    if (returnType instanceof PsiClassType) {
      return ((PsiClassType)returnType).resolve();
    }
    return null;
  }
}