/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml;

import com.intellij.ide.presentation.Presentation;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.SpringBeanIdConverter;
import com.intellij.spring.model.xml.beans.Identified;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Stubbed;
import org.jetbrains.annotations.NotNull;

/**
 * @see com.intellij.spring.model.xml.BeanTypeProvider
 */
@Stubbed
@Presentation(provider = SpringPresentationProvider.class)
public interface DomSpringBean extends CommonSpringBean, Identified {

  /**
   * Bean ID (optional, but non-empty if specified).
   *
   * @return Bean ID.
   */
  @Referencing(value = SpringBeanIdConverter.class, soft = true)
  @NotNull
  @Required(value = false)
  @Stubbed
  GenericAttributeValue<String> getId();

  void setName(@NotNull String newName);
}
