/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.converters.SpringDefaultInitDestroyRefConverter;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.converters.SpringProfilesDomConverter;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Set;

@NameStrategyForAttributes(HyphenNameStrategy.class)
@Namespace(SpringConstants.BEANS_NAMESPACE_KEY)
@Presentation(icon = "AllIcons.Nodes.Jsf.ManagedBean")
@Stubbed
public interface Beans extends DomElement, Description {

  @SubTagList(value = "beans")
  @Stubbed
  List<Beans> getBeansProfiles();

  @NotNull
  @Convert(SpringProfilesDomConverter.class)
  SpringDomProfile getProfile();

  @NotNull
  GenericAttributeValue<Boolean> getDefaultLazyInit();

  @NotNull
  GenericAttributeValue<Boolean> getDefaultMerge();

  @NotNull
  GenericAttributeValue<DefaultDependencyCheck> getDefaultDependencyCheck();

  @NotNull
  @Stubbed
  GenericAttributeValue<Autowire> getDefaultAutowire();

  @NotNull
  @Stubbed
  GenericAttributeValue<String> getDefaultAutowireCandidates();

  @Convert(value = SpringDefaultInitDestroyRefConverter.class, soft = true)
  @NotNull
  @Stubbed
  GenericAttributeValue<Set<PsiMethod>> getDefaultInitMethod();

  @NotNull
  @Convert(value = SpringDefaultInitDestroyRefConverter.class, soft = true)
  @Stubbed
  GenericAttributeValue<Set<PsiMethod>> getDefaultDestroyMethod();

  @Stubbed
  @NotNull
  List<SpringImport> getImports();

  SpringImport addImport();

  @NotNull
  @SubTagList(value = "alias")
  @Stubbed
  List<Alias> getAliases();

  @Stubbed
  @NotNull
  List<SpringBean> getBeans();

  /**
   * Adds new child to the list of bean children.
   *
   * @return created child
   */
  SpringBean addBean();

  @CustomChildren
  List<CustomBeanWrapper> getCustomBeans();
}
