/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.converters.SpringImportResourceConverter;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
 * http://www.springframework.org/schema/beans:importElemType interface.
 */
@Presentation(icon = "SpringApiIcons.SpringConfig", provider = SpringPresentationProvider.class)
public interface SpringImport extends DomElement {

  /**
   * Returns the value of the resource child.
   * <pre>
   * <h3>Attribute null:resource documentation</h3>
   * 	The relative resource location of the XML (bean definition) file to import,
   * 	for example "myImport.xml" or "includes/myImport.xml" or "../myImport.xml".
   * <p/>
   * </pre>
   *
   * @return the value of the resource child.
   */
  @NotNull
  @Required
  @Convert(SpringImportResourceConverter.class)
  @Stubbed
  GenericAttributeValue<Set<PsiFile>> getResource();
}
