/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import org.jetbrains.annotations.NotNull;

public interface CssAttribute extends CssSelectorSuffix {
  boolean isMatch(@NotNull String attributeName, @NotNull String attributeValue);

  enum OperatorType {
    NONE(""),
    EQUALS("="),
    CONTAINS_WORD("~="),
    STARTS_WITH_BEFORE_DASH("|="),
    STARTS_WITH("^="),
    ENDS_WITH("$="),
    CONTAINS("*="),
    JQUERY_NOT_EQUALS("!=");

    private final String myPresentation;

    OperatorType(String presentation) {
      myPresentation = presentation;
    }

    public String getPresentation() {
      return myPresentation;
    }

    public static OperatorType fromString(@NotNull String presentation) {
      for (OperatorType type : values()) {
        if (presentation.equals(type.myPresentation)) {
          return type;
        }
      }
      throw new IllegalArgumentException("Unknown operator type: " + presentation);
    }
  }

  @NotNull
  OperatorType getOperatorType();

  @NotNull
  String getValue();
}
