/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.ejb.facet;

import com.intellij.facet.*;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.NonNls;

import java.util.Collection;
import java.util.List;

/**
 * @author nik
 */                    
public abstract class EjbFacet extends JavaeeFacet {
  public static final FacetTypeId<EjbFacet> ID = new FacetTypeId<EjbFacet>("ejb");

  protected EjbFacet(@NotNull final FacetType facetType, @NotNull final Module module, final String name,
                     @NotNull final FacetConfiguration configuration, final Facet underlyingFacet) {
    super(facetType, module, name, configuration, underlyingFacet);
  }

  @NotNull
  public static Collection<EjbFacet> getInstances(@NotNull Module module) {
    return FacetManager.getInstance(module).getFacetsByType(ID);
  }

  @Nullable
  public abstract EjbJar getXmlRoot();

  @Nullable
  public abstract EjbRootElement getAnnotationRoot();

  @NotNull
  public abstract EjbRootElement getMergedRoot();

  @Nullable
  public abstract ConfigFile getEjbJarDescriptor();


  public abstract void addEjbSourceRoot(@NotNull @NonNls String url);
  public abstract void removeEjbSourceRoot(@NotNull @NonNls String url);
  public abstract void setEjbSourceRoots(@NotNull @NonNls String[] urls);

  @NotNull
  public abstract String[] getEjbSourceRoots();

  public abstract XmlFile getXmlDescriptor();

  public abstract List<String> getEjbSourceRootUrls();

  public abstract Collection<VirtualFile> getSourceRoots();
}
