/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.model.xml.web.converters;

import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.model.xml.Listener;
import com.intellij.javaee.model.xml.web.*;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;

import java.util.Collection;

/**
 * @author Dmitry Avdeev
 *         Date: 6/10/11
 */
public class WebDeleteHandler extends JamDeleteHandler {

  public void addPsiElements(final CommonModelElement javaeeModelElement, final Collection<PsiElement> result) {
    if (javaeeModelElement instanceof Servlet) {
      final Servlet servlet = (Servlet)javaeeModelElement;
      ContainerUtil.addIfNotNull(servlet.getServletClass().getValue(), result);
      for (final ServletMapping mapping : servlet.getParent().getServletMappings()) {
        if (servlet.equals(mapping.getServletName().getValue())) {
          result.add(mapping.getXmlTag());
        }
      }
    }
    else if (javaeeModelElement instanceof Filter) {
      final Filter filter = (Filter)javaeeModelElement;
      ContainerUtil.addIfNotNull(filter.getFilterClass().getValue(), result);
      for (final FilterMapping mapping : filter.getParent().getFilterMappings()) {
        if (filter.equals(mapping.getFilterName().getValue())) {
          result.add(mapping.getXmlTag());
        }
      }
    }
    else if (javaeeModelElement instanceof Listener) {
      ContainerUtil.addIfNotNull(((Listener)javaeeModelElement).getListenerClass().getValue(), result);
    }
  }

}
