/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashMap;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserFamily;
import com.jetbrains.quirksmode.SupportedBrowsersBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class QuirksModeSettingsPanel
extends JPanel {
    public QuirksModeSettingsPanel(@NotNull SupportedBrowsersBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/jetbrains/quirksmode/QuirksModeSettingsPanel", "<init>"));
        }
        super(new BorderLayout());
        this.add(ScrollPaneFactory.createScrollPane((Component)((Object)new QuirksTree(bean)), (int)20, (int)31));
    }

    private static class TreeDescriptor {
        private Browser myBrowser;
        private BrowserFamily myFamily;
        private SupportedBrowsersBean myBean;
        private boolean myChecked;

        public TreeDescriptor() {
        }

        public TreeDescriptor(@NotNull Browser browser, @NotNull SupportedBrowsersBean bean) {
            if (browser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/quirksmode/QuirksModeSettingsPanel$TreeDescriptor", "<init>"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/jetbrains/quirksmode/QuirksModeSettingsPanel$TreeDescriptor", "<init>"));
            }
            this(bean);
            this.myBrowser = browser;
        }

        public TreeDescriptor(@NotNull BrowserFamily family, @NotNull SupportedBrowsersBean bean) {
            if (family == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/jetbrains/quirksmode/QuirksModeSettingsPanel$TreeDescriptor", "<init>"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/jetbrains/quirksmode/QuirksModeSettingsPanel$TreeDescriptor", "<init>"));
            }
            this(bean);
            this.myFamily = family;
        }

        private TreeDescriptor(@NotNull SupportedBrowsersBean bean) {
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/jetbrains/quirksmode/QuirksModeSettingsPanel$TreeDescriptor", "<init>"));
            }
            this.myBean = bean;
        }

        public String getText() {
            return this.myBrowser == null ? (this.myFamily == null ? "" : this.myFamily.getName()) : this.myBrowser.getName();
        }

        public void setChecked(boolean b) {
            if (this.myBrowser != null) {
                this.myChecked = b;
                this.myBean.setEnabled(this.myBrowser, b);
            }
        }

        public boolean isChecked() {
            return this.myBrowser == null ? this.myChecked : this.myBean.isEnabled(this.myBrowser);
        }
    }

    private static class QuirksTree
    extends CheckboxTreeBase {
        private final SupportedBrowsersBean myBean;

        public QuirksTree(@NotNull SupportedBrowsersBean bean) {
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/jetbrains/quirksmode/QuirksModeSettingsPanel$QuirksTree", "<init>"));
            }
            super((CheckboxTreeBase.CheckboxTreeCellRendererBase)new MyTreeCellRenderer(), new CheckedTreeNode((Object)new TreeDescriptor()), new CheckboxTreeBase.CheckPolicy(true, true, false, false));
            this.myBean = bean;
            this.rebuildTree();
        }

        protected void onNodeStateChanged(CheckedTreeNode node) {
            ((TreeDescriptor)node.getUserObject()).setChecked(node.isChecked());
        }

        private void rebuildTree() {
            CheckedTreeNode root = (CheckedTreeNode)this.getModel().getRoot();
            root.removeAllChildren();
            ArrayList<BrowserFamily> sortedFamilies = new ArrayList<BrowserFamily>();
            HashMap family2browser = new HashMap();
            for (Browser browser : Browser.ALL_BROWSERS) {
                BrowserFamily family = browser.getFamily();
                ArrayList<Browser> browsers = (ArrayList<Browser>)family2browser.get((Object)family);
                if (browsers == null) {
                    browsers = new ArrayList<Browser>();
                    family2browser.put(family, browsers);
                    sortedFamilies.add(family);
                }
                browsers.add(browser);
            }
            Collections.sort(sortedFamilies, new Comparator<BrowserFamily>(){

                @Override
                public int compare(BrowserFamily o1, BrowserFamily o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (BrowserFamily family : sortedFamilies) {
                CheckedTreeNode familyNode = new CheckedTreeNode((Object)new TreeDescriptor(family, this.myBean));
                root.add((MutableTreeNode)familyNode);
                List browsers = (List)family2browser.get((Object)family);
                boolean familyChecked = false;
                for (Browser browser : browsers) {
                    CheckedTreeNode childNode = new CheckedTreeNode((Object)new TreeDescriptor(browser, this.myBean));
                    familyNode.add((MutableTreeNode)childNode);
                    boolean childChecked = this.myBean.isEnabled(browser);
                    childNode.setChecked(childChecked);
                    familyChecked |= childChecked;
                }
                familyNode.setChecked(familyChecked);
            }
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)root);
        }
    }

    private static class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof CheckedTreeNode)) {
                return;
            }
            CheckedTreeNode node = (CheckedTreeNode)value;
            TreeDescriptor descriptor = (TreeDescriptor)node.getUserObject();
            this.getTextRenderer().append(descriptor.getText(), node.isChecked() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }
}

