/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineFileStructure
extends AbstractTestFileStructure {
    private final List<JasmineSuiteStructure> mySuiteStructures;
    private final Map<String, JasmineSuiteStructure> mySuiteMap;
    private final Map<JSCallExpression, Void> myNameByCallExpressionMap;

    public JasmineFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "<init>"));
        }
        super(jsFile);
        this.mySuiteStructures = Lists.newArrayList();
        this.mySuiteMap = Maps.newHashMap();
        this.myNameByCallExpressionMap = ContainerUtil.newIdentityHashMap();
    }

    @NotNull
    public List<JasmineSuiteStructure> getSuites() {
        List<JasmineSuiteStructure> list = this.mySuiteStructures;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "getSuites"));
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasJasmineSymbols();
    }

    public boolean containsCallExpression(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "containsCallExpression"));
        }
        return this.myNameByCallExpressionMap.containsKey(callExpression);
    }

    public void addSuiteStructure(JasmineSuiteStructure suiteStructure) {
        this.mySuiteStructures.add(suiteStructure);
    }

    @Nullable
    public JasmineSuiteStructure findTopLevelSuiteByName(String suiteName) {
        return this.mySuiteMap.get(suiteName);
    }

    public int getTopLevelSuiteCount() {
        return this.mySuiteStructures.size();
    }

    public boolean hasJasmineSymbols() {
        return this.getTopLevelSuiteCount() > 0;
    }

    @Nullable
    public JasmineSuiteStructure findLowestSuiteStructureContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.mySuiteStructures) {
            JasmineSuiteStructure inner = suiteStructure.findLowestSuiteStructureContainingOffset(offset);
            if (inner == null) continue;
            return inner;
        }
        return null;
    }

    @Nullable
    public JasmineSpecStructure findSpecContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.mySuiteStructures) {
            JasmineSpecStructure specStructure = suiteStructure.findSpecContainingOffset(offset);
            if (specStructure == null) continue;
            return specStructure;
        }
        return null;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "findJstdRunElement"));
        }
        JsTestElementPath testElementPath = this.findTestElementPath(textRange);
        if (testElementPath == null) {
            return null;
        }
        return new JstdRunElement(StringUtil.join(testElementPath.getSuiteNames(), (String)" "), testElementPath.getTestName());
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "findJasmineElement"));
        }
        for (JasmineSuiteStructure suiteStructure : this.mySuiteStructures) {
            AbstractJasmineElement result = suiteStructure.findJasmineElement(textRange);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange textRange) {
        JSCallExpression psiElement;
        JasmineSuiteStructure suiteStructure;
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "findTestElementPath"));
        }
        AbstractJasmineElement element = this.findJasmineElement(textRange);
        if (element == null) {
            return null;
        }
        String specName = null;
        if (element instanceof JasmineSuiteStructure) {
            suiteStructure = (JasmineSuiteStructure)element;
            psiElement = suiteStructure.getEnclosingCallExpression();
        } else {
            JasmineSpecStructure specStructure = (JasmineSpecStructure)element;
            suiteStructure = element.getParent();
            specName = element.getName();
            psiElement = specStructure.getEnclosingCallExpression();
        }
        List suites = ContainerUtil.newSmartList();
        while (suiteStructure != null) {
            suites.add(suiteStructure.getName());
            suiteStructure = suiteStructure.getParent();
        }
        Collections.reverse(suites);
        return new JsTestElementPath(suites, specName, (PsiElement)psiElement);
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> suiteNames, @Nullable String testName) {
        if (suiteNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteNames", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "findPsiElement"));
        }
        if (suiteNames.isEmpty()) {
            return null;
        }
        JasmineSuiteStructure suiteStructure = this.mySuiteMap.get(suiteNames.get(0));
        if (suiteStructure == null) {
            return null;
        }
        for (int i = 1; i < suiteNames.size(); ++i) {
            if ((suiteStructure = suiteStructure.getInnerSuiteByName(suiteNames.get(i))) != null) continue;
            return null;
        }
        if (testName == null) {
            return suiteStructure.getEnclosingCallExpression();
        }
        JasmineSpecStructure specStructure = suiteStructure.getInnerSpecByName(testName);
        if (specStructure != null) {
            return specStructure.getEnclosingCallExpression();
        }
        return null;
    }

    @Override
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "findPsiElement"));
        }
        JasmineSuiteStructure suite = this.findSuite(testCaseName);
        if (suite == null) {
            return null;
        }
        if (testMethodName == null) {
            return suite.getEnclosingCallExpression();
        }
        JasmineSpecStructure spec = suite.getInnerSpecByName(testMethodName);
        if (spec != null) {
            return spec.getEnclosingCallExpression();
        }
        return null;
    }

    @Nullable
    private JasmineSuiteStructure findSuite(@NotNull String suiteName) {
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "findSuite"));
        }
        JasmineSuiteStructure suite = this.mySuiteMap.get(suiteName);
        if (suite != null) {
            return suite;
        }
        int ind = suiteName.lastIndexOf(32);
        while (ind >= 0) {
            String suffix;
            JasmineSuiteStructure res;
            String prefix = suiteName.substring(0, ind);
            suite = this.mySuiteMap.get(prefix);
            if (suite != null && (res = suite.findSuite(suffix = suiteName.substring(ind + 1))) != null) {
                return res;
            }
            ind = suiteName.lastIndexOf(32, ind - 1);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        if (this.mySuiteStructures.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "getTopLevelElements"));
            }
            return list;
        }
        ArrayList<String> out = new ArrayList<String>(this.mySuiteStructures.size());
        for (JasmineSuiteStructure structure : this.mySuiteStructures) {
            out.add(structure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "getTopLevelElements"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        if (topLevelElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelElementName", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "getChildrenOf"));
        }
        JasmineSuiteStructure suiteStructure = this.mySuiteMap.get(topLevelElementName);
        if (suiteStructure == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "getChildrenOf"));
            }
            return list;
        }
        ArrayList<String> out = new ArrayList<String>(suiteStructure.getSpecCount());
        for (JasmineSpecStructure specStructure : suiteStructure.getSpecs()) {
            out.add(specStructure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "getChildrenOf"));
        }
        return arrayList;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "contains"));
        }
        return this.findPsiElement(testCaseName, testMethodName) != null;
    }

    void postProcess() {
        for (JasmineSuiteStructure suite : this.mySuiteStructures) {
            this.processSuite(suite);
        }
        this.mergeTopLevelSuites();
    }

    private void mergeTopLevelSuites() {
        Iterator<JasmineSuiteStructure> it = this.mySuiteStructures.iterator();
        while (it.hasNext()) {
            JasmineSuiteStructure suite = it.next();
            JasmineSuiteStructure prevSuite = this.mySuiteMap.get(suite.getName());
            if (prevSuite == null) {
                this.mySuiteMap.put(suite.getName(), suite);
                continue;
            }
            prevSuite.mergeWith(suite);
            it.remove();
        }
    }

    private void processSuite(@NotNull JasmineSuiteStructure suite) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructure", "processSuite"));
        }
        for (JasmineSuiteStructure childSuite : suite.getSuites()) {
            this.processSuite(childSuite);
        }
        suite.fillNameMap();
        this.myNameByCallExpressionMap.put(suite.getEnclosingCallExpression(), null);
        for (JasmineSpecStructure spec : suite.getSpecs()) {
            this.myNameByCallExpressionMap.put(spec.getEnclosingCallExpression(), null);
        }
    }
}

