/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.security.model.xml.LdapUserService;
import com.intellij.spring.security.model.xml.UserDetailsClass;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityUserPropertyReferenceProvider
extends PsiReferenceProvider {
    private static final List<String> ALLOWED_DEFAULT_PROPERTIES = Arrays.asList("username");
    private static final NullableFunction<PsiMethod, BeanProperty> BEAN_PROPERTY_MAPPER = new NullableFunction<PsiMethod, BeanProperty>(){

        @Nullable
        public BeanProperty fun(PsiMethod method) {
            return BeanProperty.createBeanProperty((PsiMethod)method);
        }
    };
    private static final Function<BeanProperty, PsiNamedElement> BEAN_PROPERTY_PSI_MAPPER = new Function<BeanProperty, PsiNamedElement>(){

        public PsiNamedElement fun(BeanProperty beanProperty) {
            return beanProperty.getPsiElement();
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = SpringSecurityUserPropertyReferenceProvider.createReferences(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider", "createReferences"));
        }
        return new PsiReference[]{new UserPropertyReference(element)};
    }

    private static List<BeanProperty> getAllBeanProperties(PsiElement element, @Nullable Module module) {
        if (module == null) {
            return Collections.emptyList();
        }
        PsiClass userDetailsClazz = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.core.userdetails.UserDetails");
        if (userDetailsClazz == null) {
            return Collections.emptyList();
        }
        Collection userDetailsImplementations = ClassInheritorsSearch.search((PsiClass)userDetailsClazz, (SearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module), (boolean)true).findAll();
        PsiClass userDetailsImpl = null;
        if (userDetailsImplementations.size() == 1) {
            userDetailsImpl = (PsiClass)userDetailsImplementations.iterator().next();
        } else {
            PsiClass ldapUserDetailsService = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.ldap.userdetails.LdapUserDetailsService");
            if (ldapUserDetailsService != null) {
                SpringBeanPointer ldapUserDetailsPointer;
                CommonSpringBean bean;
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)ldapUserDetailsService).withInheritors();
                CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(element);
                List ldapUserDetailsPointers = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
                if (ldapUserDetailsPointers.size() == 1 && (bean = (ldapUserDetailsPointer = (SpringBeanPointer)ldapUserDetailsPointers.get(0)).getSpringBean()) instanceof LdapUserService) {
                    LdapUserService ldapUserService = (LdapUserService)bean;
                    UserDetailsClass userDetailsClass = (UserDetailsClass)((Object)ldapUserService.getUserDetailsClass().getValue());
                    if (userDetailsClass == UserDetailsClass.INET_ORG_PERSON) {
                        userDetailsImpl = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.ldap.userdetails.InetOrgPerson");
                    } else if (userDetailsClass == UserDetailsClass.PERSON) {
                        userDetailsImpl = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.ldap.userdetails.Person");
                    }
                }
            }
        }
        if (userDetailsImpl == null) {
            userDetailsImpl = userDetailsClazz;
        }
        Map properties = PropertyUtil.getAllProperties((PsiClass)userDetailsImpl, (boolean)false, (boolean)true, (boolean)false);
        for (String blacklistedProperty : PropertyUtil.getReadableProperties((PsiClass)userDetailsClazz, (boolean)false)) {
            if (ALLOWED_DEFAULT_PROPERTIES.contains(blacklistedProperty)) continue;
            properties.remove(blacklistedProperty);
        }
        return ContainerUtil.mapNotNull(properties.values(), BEAN_PROPERTY_MAPPER);
    }

    private static class UserPropertyReference
    extends PsiReferenceBase<PsiElement> {
        private final List<BeanProperty> properties;

        private UserPropertyReference(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider$UserPropertyReference", "<init>"));
            }
            super(element, true);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            this.properties = SpringSecurityUserPropertyReferenceProvider.getAllBeanProperties(element, module);
        }

        public PsiElement resolve() {
            BeanProperty beanProperty = (BeanProperty)ContainerUtil.find(this.properties, (Condition)new Condition<BeanProperty>(){

                public boolean value(BeanProperty beanProperty) {
                    return Comparing.strEqual((String)this.getValue(), (String)beanProperty.getName());
                }
            });
            return beanProperty != null ? beanProperty.getMethod() : null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array(this.properties, PsiNamedElement.class, (Function)BEAN_PROPERTY_PSI_MAPPER);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider$UserPropertyReference", "getVariants"));
            }
            return objectArray;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String name = PropertyUtil.getPropertyName((String)newElementName);
            return super.handleElementRename(name == null ? newElementName : name);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String propertyName;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityUserPropertyReferenceProvider$UserPropertyReference", "bindToElement"));
            }
            if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
                return super.handleElementRename(propertyName);
            }
            return this.getElement();
        }
    }
}

