/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.security.model.xml.FormLogin;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.model.xml.Logout;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityWebPathProvider
extends PathReferenceProviderBase {
    private static final String J_SPRING_SECURITY_CHECK = "/j_spring_security_check";
    private static final String J_SPRING_SECURITY_LOGOUT = "/j_spring_security_logout";

    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/security/references/SpringSecurityWebPathProvider", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/spring/security/references/SpringSecurityWebPathProvider", "createReferences"));
        }
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiElement.getContainingFile())) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.core.Authentication") == null) {
            return true;
        }
        final List<String> springSecurityURLs = SpringSecurityWebPathProvider.getSpringSecurityURLs(module);
        boolean isSpringSecurityUrl = springSecurityURLs.contains(text);
        references.add((PsiReference)new PsiReferenceBase.Immediate<PsiElement>(psiElement, (PsiElement)(isSpringSecurityUrl ? psiElement : null)){

            @NotNull
            public Object[] getVariants() {
                ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(springSecurityURLs.size());
                for (String url : springSecurityURLs) {
                    variants.add(LookupElementBuilder.create((String)url).withIcon(SpringApiIcons.Spring).withTailText(" (Spring Security)", true));
                }
                Object[] objectArray = variants.toArray(new LookupElementBuilder[variants.size()]);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityWebPathProvider$1", "getVariants"));
                }
                return objectArray;
            }
        });
        return true;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/spring/security/references/SpringSecurityWebPathProvider", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityWebPathProvider", "getPathReference"));
        }
        return null;
    }

    private static List<String> getSpringSecurityURLs(Module module) {
        SmartList urls = new SmartList();
        boolean foundCustomLogin = false;
        boolean foundCustomLogout = false;
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            if (!(model instanceof XmlSpringModel)) continue;
            Set roots = ((XmlSpringModel)model).getLocalModelsRoots();
            for (DomFileElement domFileElement : roots) {
                if (!SpringDomUtils.hasElement((DomFileElement)domFileElement, Http.class)) continue;
                List https = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), Http.class, (boolean)true, (boolean)false);
                for (Http http : https) {
                    for (FormLogin login : http.getFormLogins()) {
                        String loginUrl = login.getLoginProcessingUrl().getStringValue();
                        if (!StringUtil.isNotEmpty((String)loginUrl)) continue;
                        urls.add(loginUrl);
                        foundCustomLogin = true;
                    }
                    for (Logout logout : http.getLogouts()) {
                        String logoutUrl = logout.getLogoutUrl().getStringValue();
                        if (!StringUtil.isNotEmpty((String)logoutUrl)) continue;
                        urls.add(logoutUrl);
                        foundCustomLogout = true;
                    }
                }
            }
        }
        if (!foundCustomLogin) {
            urls.add(J_SPRING_SECURITY_CHECK);
        }
        if (!foundCustomLogout) {
            urls.add(J_SPRING_SECURITY_LOGOUT);
        }
        return urls;
    }
}

