/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgent;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServices;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesImpl;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettings;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsImpl;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFEnvVar;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFEnvVarImpl;
import com.intellij.javaee.cloudfoundry.cloud.CFManifest;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentDeploymentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.CloudApplicationRuntimeBase;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CFDeploymentRuntime
extends CloudApplicationRuntimeBase {
    private final LoggingHandler myMainLoggingHandler;
    private final List<String> myAppUrls;
    private final DeploymentLogManager myLogManager;
    private final CloudAgentDeployment myDeployment;
    private final boolean myNoRoute;

    public CFDeploymentRuntime(ServerTaskExecutor tasksExecutor, CFCloudAgent agent, final String deploymentName, List<String> appUrls, DeploymentTask<CFDeploymentConfiguration> task, DeploymentLogManager logManager) {
        super(tasksExecutor, deploymentName);
        List<String> configServiceNames;
        Integer configInstances;
        CFAppSettings configAppSettings;
        Integer configMemory;
        Integer instances;
        this.myAppUrls = appUrls;
        this.myLogManager = logManager;
        this.myMainLoggingHandler = logManager.getMainLoggingHandler();
        final DeploymentSource source = task.getSource();
        final CFDeploymentConfiguration configuration = (CFDeploymentConfiguration)task.getConfiguration();
        final CFManifest manifest = configuration.getManifest();
        this.myNoRoute = manifest.noRoute();
        final CFAppSettingsImpl appSettings = new CFAppSettingsImpl();
        Integer memory = manifest.getMemory();
        if (memory != null && memory > 0) {
            appSettings.setMemory(memory);
        }
        if ((instances = manifest.getInstances()) != null && instances > 0) {
            appSettings.setInstances(instances);
        }
        if ((configMemory = (configAppSettings = configuration.getApplicationSettings()).getMemory()) != null) {
            appSettings.setMemory(configMemory);
        }
        if ((configInstances = configAppSettings.getInstances()) != null) {
            appSettings.setInstances(configInstances);
        }
        final CFAppServicesImpl appServices = new CFAppServicesImpl();
        List<String> serviceNames = manifest.getApplicationServices();
        if (!serviceNames.isEmpty()) {
            appServices.setServiceNames(serviceNames);
        }
        if (!(configServiceNames = configuration.getApplicationServices().getServiceNames()).isEmpty()) {
            appServices.setServiceNames(configServiceNames);
        }
        this.myDeployment = agent.createDeployment(new CFCloudAgentDeploymentConfiguration(){

            public String getDeploymentName() {
                return deploymentName;
            }

            public File getFile() {
                return source.getFile();
            }

            @Override
            public CFAppSettings getApplicationSettings() {
                return appSettings;
            }

            @Override
            public CFAppServices getApplicationServices() {
                return appServices;
            }

            @Override
            public String[] getAppUrls() {
                return CFDeploymentRuntime.this.myNoRoute ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray((Collection)CFDeploymentRuntime.this.myAppUrls);
            }

            @Override
            public String getAppType() {
                return configuration.getType().getAppType();
            }

            @Override
            public String getInfra() {
                return configuration.getInfra();
            }

            @Override
            public String getBuildPackUrl() {
                return manifest.getBuildpackUrl();
            }

            @Override
            public String getCommand() {
                return manifest.getCommand();
            }

            @Override
            public Integer getDiskQuota() {
                return manifest.getDiskQuota();
            }

            @Override
            public String getStack() {
                return manifest.getStack();
            }

            @Override
            public CFEnvVar[] getEnvs() {
                return (CFEnvVar[])ContainerUtil.map2Array(manifest.getEnvs().entrySet(), CFEnvVar.class, (Function)new Function<Map.Entry<String, String>, CFEnvVar>(){

                    public CFEnvVar fun(Map.Entry<String, String> entry) {
                        return new CFEnvVarImpl(entry.getKey(), entry.getValue());
                    }
                });
            }

            @Override
            public Integer getTimeout() {
                return manifest.getTimeout();
            }
        }, (CloudAgentLoggingHandler)new CloudLoggingHandlerImpl(this.myLogManager));
    }

    protected CloudAgentApplication getApplication() {
        return this.myDeployment;
    }

    public void deploy(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.myDeployment.deploy(new CloudAgentDeploymentCallback(){

            public void succeeded() {
                if (CFDeploymentRuntime.this.myNoRoute) {
                    callback.succeeded((DeploymentRuntime)CFDeploymentRuntime.this);
                    return;
                }
                CFDeploymentRuntime.this.myMainLoggingHandler.print("Application is available at ");
                boolean first = true;
                for (String appUrl : CFDeploymentRuntime.this.myAppUrls) {
                    if (first) {
                        first = false;
                    } else {
                        CFDeploymentRuntime.this.myMainLoggingHandler.print(", ");
                    }
                    CFDeploymentRuntime.this.myMainLoggingHandler.printHyperlink(appUrl);
                }
                CFDeploymentRuntime.this.myMainLoggingHandler.print("\n");
                callback.succeeded((DeploymentRuntime)CFDeploymentRuntime.this);
            }

            public void errorOccurred(String errorMessage) {
                callback.errorOccurred(errorMessage);
            }
        });
    }
}

