/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgent;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRange;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRangeImpl;
import com.intellij.javaee.cloudfoundry.cloud.CFCloudLocation;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentRuntime;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.cloud.agent.CloudListWrapper;
import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentBase;
import com.intellij.remoteServer.agent.util.CloudAgentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudApplicationRuntimeImpl;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CFServerRuntimeInstanceBase<CA extends CFCloudAgent>
extends CloudServerRuntimeInstance<CFDeploymentConfiguration, CA, CFServerConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CFServerRuntimeInstanceBase.class.getName()));
    private static final String SPECIFICS_JAR_PATH = "specifics/cloudFoundrySpecifics.jar";

    protected CFServerRuntimeInstanceBase(CFServerConfiguration configuration, ServerTaskExecutor taskExecutor, @NotNull List<File> libraryFiles, String specificsModuleName, Class<CA> agentInterface, String agentClassName) throws Exception {
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase", "<init>"));
        }
        super((CloudAgentConfigBase)configuration, taskExecutor, libraryFiles, Arrays.asList(CFCloudAgentBase.class, ILogger.class, CloudListWrapper.class), specificsModuleName, SPECIFICS_JAR_PATH, agentInterface, agentClassName);
    }

    public void connect(final ServerConnector.ConnectionCallback<CFDeploymentConfiguration> callback) {
        ((CFCloudAgent)this.getAgent()).connect((CFCloudAgentConfiguration)this.getConfiguration(), new CloudAgentCallback(){

            public void connected() {
                callback.connected((ServerRuntimeInstance)CFServerRuntimeInstanceBase.this);
            }

            public void errorOccurred(String errorMessage) {
                callback.errorOccurred(errorMessage);
            }
        }, new CloudAgentLogger(){

            public void debugEx(Exception e) {
                LOG.debug((Throwable)e);
            }

            public void debug(String message) {
                LOG.debug(message);
            }
        }, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, CFDeploymentConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase", "getDeploymentName"));
        }
        String manifestApplicationName = configuration.getManifest().getCurrentApplication();
        String string = StringUtil.isEmpty((String)manifestApplicationName) ? CFCloudLocation.NAME_PROVIDER.getDeploymentName(source) : manifestApplicationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase", "getDeploymentName"));
        }
        return string;
    }

    public void deploy(final @NotNull DeploymentTask<CFDeploymentConfiguration> task, final @NotNull DeploymentLogManager logManager, final @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/cloudfoundry/cloud/CFServerRuntimeInstanceBase", "deploy"));
        }
        DeploymentSource deploymentSource = task.getSource();
        File source = deploymentSource.getFile();
        if (source == null) {
            callback.errorOccurred(JavaeeBundle.getText((String)"ServerInstance.invalid.deployment.source", (Object[])new Object[]{deploymentSource.getPresentableName()}));
            return;
        }
        final String deploymentName = this.getDeploymentName(deploymentSource, (CFDeploymentConfiguration)task.getConfiguration());
        final List<String> appUrls = ((CFServerConfiguration)this.getConfiguration()).getLocationAppUrls(task);
        this.getTaskExecutor().submit((ThrowableRunnable)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                ((CFDeploymentConfiguration)task.getConfiguration()).getManifest().validate();
                new CFDeploymentRuntime(CFServerRuntimeInstanceBase.this.getTaskExecutor(), (CFCloudAgent)CFServerRuntimeInstanceBase.this.getAgent(), deploymentName, appUrls, (DeploymentTask<CFDeploymentConfiguration>)task, logManager).deploy(callback);
            }
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(new Runnable(){

            @Override
            public void run() {
                ((CFCloudAgent)CFServerRuntimeInstanceBase.this.getAgent()).disconnect();
            }
        });
    }

    public CFAppSettingsRange getAppSettingsRange() throws ServerRuntimeException {
        return (CFAppSettingsRange)this.getAgentTaskExecutor().execute((Computable)new Computable<CFAppSettingsRange>(){

            public CFAppSettingsRange compute() {
                return new CFAppSettingsRangeImpl(((CFCloudAgent)CFServerRuntimeInstanceBase.this.getAgent()).getAppSettingsRange());
            }
        });
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new CloudApplicationRuntimeImpl(this.getTaskExecutor(), (CloudAgentBase)this.getAgent(), application);
    }
}

