/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.util.PseudoImplLightClass;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjPsiUtil {
    private static final String ASPECT_ANNOTATION = "org.aspectj.lang.annotation.Aspect";

    private AjPsiUtil() {
    }

    @Nullable
    public static PsiClass getContainingClass(@NotNull PsiInterTypeDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getContainingClass"));
        }
        PsiClass aClass = declaration.getInterTypeReference().getReferencedClass();
        if (aClass == null || !aClass.isInterface()) {
            return aClass;
        }
        return AjPsiUtil.getPseudoImplClass(aClass);
    }

    @NotNull
    private static PsiClass getPseudoImplClass(final @NotNull PsiClass anInterface) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getPseudoImplClass"));
        }
        PsiClass psiClass = (PsiClass)CachedValuesManager.getCachedValue((PsiElement)anInterface, (CachedValueProvider)new CachedValueProvider<PsiClass>(){

            public CachedValueProvider.Result<PsiClass> compute() {
                return CachedValueProvider.Result.create((Object)((Object)new PseudoImplLightClass(anInterface)), (Object[])new Object[]{anInterface});
            }
        });
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getPseudoImplClass"));
        }
        return psiClass;
    }

    @Nullable
    public static PsiElement getContainingClassIdentifier(@NotNull PsiInterTypeDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getContainingClassIdentifier"));
        }
        PsiClass refClass = declaration.getInterTypeReference().getReferencedClass();
        return refClass != null ? refClass.getNameIdentifier() : null;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfType(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getChildrenOfType"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getChildrenOfType"));
        }
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            PsiElement t = child;
            result.add(t);
        }
        LinkedList<PsiElement> linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "getChildrenOfType"));
        }
        return linkedList;
    }

    public static boolean isInjectionInsideInterType(@NotNull PsiElement element) {
        InjectedLanguageManager injectionManager;
        PsiElement[] elements;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/psi/util/AjPsiUtil", "isInjectionInsideInterType"));
        }
        SearchScope useScope = element.getUseScope();
        if (useScope instanceof LocalSearchScope && (elements = ((LocalSearchScope)useScope).getScope()).length == 1 && elements[0] instanceof PsiFile && (injectionManager = InjectedLanguageManager.getInstance((Project)element.getProject())).isInjectedFragment((PsiFile)elements[0])) {
            PsiLanguageInjectionHost host = injectionManager.getInjectionHost(element);
            return PsiTreeUtil.getParentOfType((PsiElement)host, PsiInterTypeDeclaration.class) != null;
        }
        return false;
    }

    public static boolean isAspect(@Nullable PsiElement element) {
        return element instanceof PsiAspect || element instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)element), (String)ASPECT_ANNOTATION, (boolean)false);
    }
}

