/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyManagerImpl
extends SpringBootApplicationMetaConfigKeyManager
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "runActivity"));
        }
        CompilerManager.getInstance((Project)project).addAfterTask(new CompileTask(){

            public boolean execute(final CompileContext context) {
                boolean projectHasSpringBoot;
                DumbService dumbService = DumbService.getInstance((Project)context.getProject());
                boolean bl = projectHasSpringBoot = dumbService.isDumb() || (Boolean)dumbService.runReadActionInSmartMode((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return SpringBootLibraryUtil.hasSpringBootLibrary(context.getProject());
                    }
                }) != false;
                if (!projectHasSpringBoot) {
                    return true;
                }
                SmartList jsonFilesToRefresh = new SmartList();
                for (final Module module : context.getCompileScope().getAffectedModules()) {
                    VirtualFile outputDirectory;
                    boolean hasAnnotationProcessor;
                    boolean bl2 = hasAnnotationProcessor = dumbService.isDumb() || (Boolean)dumbService.runReadActionInSmartMode((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            return SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module);
                        }
                    }) != false;
                    if (!hasAnnotationProcessor || (outputDirectory = context.getModuleOutputDirectory(module)) == null) continue;
                    String path = outputDirectory.getPath() + "/META-INF/" + "spring-configuration-metadata.json";
                    jsonFilesToRefresh.add(new File(path));
                }
                CompilerUtil.refreshIOFiles((Collection)jsonFilesToRefresh);
                if (!jsonFilesToRefresh.isEmpty()) {
                    DaemonCodeAnalyzer.getInstance((Project)context.getProject()).restart();
                }
                return true;
            }
        });
    }

    public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(final @Nullable Module module) {
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return Collections.emptyList();
        }
        List fromLibraries = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<List<SpringBootApplicationMetaConfigKey>>(){

            @Nullable
            public CachedValueProvider.Result<List<SpringBootApplicationMetaConfigKey>> compute() {
                List metaInfConfigFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)false, (String)"spring-configuration-metadata.json", JsonFile.class);
                List allKeys = SpringBootApplicationMetaConfigKeyManagerImpl.collectKeys(null, metaInfConfigFiles);
                ArrayList<ProjectRootManager> allDependencies = new ArrayList<ProjectRootManager>(metaInfConfigFiles);
                allDependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
                return CachedValueProvider.Result.create((Object)allKeys, allDependencies);
            }
        });
        List<SpringBootApplicationMetaConfigKey> localKeys = SpringBootApplicationMetaConfigKeyManagerImpl.getLocalMetaConfigKeys(module);
        return ContainerUtil.concat((List)fromLibraries, localKeys);
    }

    private static List<SpringBootApplicationMetaConfigKey> getLocalMetaConfigKeys(final Module module) {
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<List<SpringBootApplicationMetaConfigKey>>(){

            @Nullable
            public CachedValueProvider.Result<List<SpringBootApplicationMetaConfigKey>> compute() {
                HashSet allModules = new HashSet();
                ModuleUtilCore.getDependencies((Module)module, (Set)allModules);
                boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
                if (ContainerUtil.process((Iterable)allModules, (Processor)new Processor<Module>(){

                    public boolean process(Module module) {
                        return !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module);
                    }
                })) {
                    Key libraryCheckDependency = unitTestMode ? PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT : ProjectRootManager.getInstance((Project)module.getProject());
                    return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{libraryCheckDependency});
                }
                ArrayList result = new ArrayList();
                for (Module module2 : allModules) {
                    VirtualFile child;
                    if (!unitTestMode) {
                        String outputDir = CompilerPaths.getModuleOutputPath((Module)module2, (boolean)false);
                        if (outputDir == null) continue;
                        String metadataJsonPath = outputDir + "/META-INF/" + "spring-configuration-metadata.json";
                        child = LocalFileSystem.getInstance().findFileByPath(metadataJsonPath);
                    } else {
                        child = TempFileSystem.getInstance().findFileByPath("/src/spring-configuration-metadata.json");
                    }
                    if (child == null) continue;
                    child.refresh(true, false);
                    PsiFile psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(child);
                    if (!(psiFile instanceof JsonFile)) continue;
                    result.addAll(SpringBootApplicationMetaConfigKeyManagerImpl.collectKeys(module2, Collections.singletonList((JsonFile)psiFile)));
                }
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    @NotNull
    private static List<SpringBootApplicationMetaConfigKey> collectKeys(@Nullable Module fromLocalModule, List<JsonFile> allConfigFiles) {
        ArrayList<SpringBootApplicationMetaConfigKey> result = new ArrayList<SpringBootApplicationMetaConfigKey>();
        CommonProcessors.CollectProcessor collect = new CommonProcessors.CollectProcessor(result);
        for (JsonFile configMetadataFile : allConfigFiles) {
            SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(fromLocalModule, configMetadataFile);
            parser.processKeys((Processor<SpringBootApplicationMetaConfigKey>)collect);
        }
        ArrayList<SpringBootApplicationMetaConfigKey> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "collectKeys"));
        }
        return arrayList;
    }

    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        if (configKey == null || module == null) {
            return null;
        }
        List<SpringBootApplicationMetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            return null;
        }
        SpringBootApplicationMetaConfigKey exact = (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createStrictConfigKeyCondition(configKey));
        if (exact != null) {
            return exact;
        }
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createRelaxedConfigKeyCondition(configKey));
    }

    @NotNull
    public List<SpringBootApplicationMetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement, @Nullable String configKey) {
        if (configKey == null) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List allKeys = this.getAllMetaConfigKeys(psiElement);
        if (allKeys.isEmpty()) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List exact = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createStrictConfigKeyCondition(configKey));
        if (!exact.isEmpty()) {
            List list = exact;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List list = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createRelaxedConfigKeyCondition(configKey));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
        }
        return list;
    }

    @NotNull
    private static Condition<SpringBootApplicationMetaConfigKey> createStrictConfigKeyCondition(final @Nullable String configKey) {
        Condition<SpringBootApplicationMetaConfigKey> condition = new Condition<SpringBootApplicationMetaConfigKey>(){

            public boolean value(SpringBootApplicationMetaConfigKey key) {
                return key.getName().equals(configKey);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "createStrictConfigKeyCondition"));
        }
        return condition;
    }

    private static Condition<SpringBootApplicationMetaConfigKey> createRelaxedConfigKeyCondition(final String configKey) {
        return new Condition<SpringBootApplicationMetaConfigKey>(){

            public boolean value(SpringBootApplicationMetaConfigKey key) {
                return key.matches(configKey);
            }
        };
    }
}

