/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.ConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyImpl;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootConfigurationMetadataParser {
    @Nullable
    private final Module myLocalModule;
    private final JsonFile myJsonFile;
    private final String myLibraryName;
    private final JavaPsiFacade myJavaPsiFacade;
    private final PsiElementFactory myElementFactory;
    private final GlobalSearchScope mySearchScope;
    private final Map<String, PsiType> myCachedTypes = new FactoryMap<String, PsiType>(){

        @Nullable
        protected PsiType create(String key) {
            return SpringBootConfigurationMetadataParser.this.myElementFactory.createTypeFromText(key.replace('$', '.'), (PsiElement)SpringBootConfigurationMetadataParser.this.myJsonFile);
        }
    };
    private final Map<String, PsiClass> myCachedClass = new FactoryMap<String, PsiClass>(){

        @Nullable
        protected PsiClass create(String key) {
            return SpringBootConfigurationMetadataParser.this.myJavaPsiFacade.findClass(key.replace('$', '.'), SpringBootConfigurationMetadataParser.this.mySearchScope);
        }
    };
    private final Map<PsiType, SpringBootApplicationMetaConfigKey.AccessType> myCachedAccessType = new FactoryMap<PsiType, SpringBootApplicationMetaConfigKey.AccessType>(){

        @Nullable
        protected SpringBootApplicationMetaConfigKey.AccessType create(PsiType key) {
            if (key instanceof PsiArrayType) {
                return SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
            }
            PsiClass resolve = PsiTypesUtil.getPsiClass((PsiType)key);
            if (resolve == null) {
                return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
            }
            String fqn = resolve.getQualifiedName();
            if ("java.util.Map".equals(fqn)) {
                return SpringBootApplicationMetaConfigKey.AccessType.MAP;
            }
            if ("java.util.List".equals(fqn)) {
                return SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
            }
            return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
        }
    };
    private final NotNullLazyValue<Map<String, PsiElement>> myAdditionalConfigTargets = new NotNullLazyValue<Map<String, PsiElement>>(){

        @NotNull
        protected Map<String, PsiElement> compute() {
            if (SpringBootConfigurationMetadataParser.this.myLocalModule == null) {
                Map<String, PsiElement> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser$4", "compute"));
                }
                return map;
            }
            final HashMap<String, PsiElement> additionalConfigTargets = new HashMap<String, PsiElement>();
            SpringBootAdditionalConfigUtils utils = new SpringBootAdditionalConfigUtils(SpringBootConfigurationMetadataParser.this.myLocalModule);
            utils.processAdditionalMetadataFiles(new Processor<JsonFile>(){

                public boolean process(JsonFile file) {
                    com.intellij.json.psi.JsonObject rootObject = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), com.intellij.json.psi.JsonObject.class);
                    if (rootObject == null) {
                        return true;
                    }
                    JsonProperty propertiesRoot = rootObject.findProperty("properties");
                    if (propertiesRoot == null) {
                        return true;
                    }
                    JsonArray propertiesArray = (JsonArray)ObjectUtils.tryCast((Object)propertiesRoot.getValue(), JsonArray.class);
                    if (propertiesArray == null) {
                        return true;
                    }
                    for (JsonValue value : propertiesArray.getValueList()) {
                        String key;
                        JsonStringLiteral nameValue;
                        JsonProperty nameProperty;
                        com.intellij.json.psi.JsonObject object = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)value, com.intellij.json.psi.JsonObject.class);
                        if (object == null || (nameProperty = object.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.isNotEmpty((String)(key = JsonPsiUtil.stripQuotes((String)nameValue.getValue())))) continue;
                        additionalConfigTargets.put(key, nameProperty);
                    }
                    return true;
                }
            });
            HashMap<String, PsiElement> hashMap = additionalConfigTargets;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser$4", "compute"));
            }
            return hashMap;
        }
    };

    SpringBootConfigurationMetadataParser(@Nullable Module localModule, JsonFile jsonFile) {
        this.myLocalModule = localModule;
        this.myJsonFile = jsonFile;
        this.myLibraryName = this.getLibraryName();
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)this.myJsonFile.getProject());
        this.myElementFactory = this.myJavaPsiFacade.getElementFactory();
        this.mySearchScope = this.myJsonFile.getResolveScope();
    }

    private String getLibraryName() {
        if (this.myLocalModule != null) {
            return this.myLocalModule.getName();
        }
        OrderEntry libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)this.myJsonFile.getVirtualFile(), (Project)this.myJsonFile.getProject());
        if (libraryEntry instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)libraryEntry).getLibraryName();
            if (libraryName != null) {
                return libraryName;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getLocalByEntry(this.myJsonFile.getVirtualFile());
            if (jarRoot != null) {
                return jarRoot.getName();
            }
        }
        return "<unknown>";
    }

    boolean processKeys(Processor<SpringBootApplicationMetaConfigKey> processor) {
        JsonObject rootObject;
        try {
            String content = VfsUtilCore.loadText((VirtualFile)this.myJsonFile.getVirtualFile());
            JsonReader reader = new JsonReader((Reader)new CharSequenceReader((CharSequence)content));
            reader.setLenient(true);
            JsonElement parse = new JsonParser().parse(reader);
            if (!parse.isJsonObject()) {
                return true;
            }
            rootObject = parse.getAsJsonObject();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Error parsing JSON " + this.myJsonFile.getVirtualFile().getPath(), e);
        }
        JsonElement propertiesElement = rootObject.get("properties");
        if (propertiesElement == null) {
            return true;
        }
        com.google.gson.JsonArray properties = propertiesElement.getAsJsonArray();
        Map<String, SpringBootApplicationMetaConfigKey.ItemHint> hints = SpringBootConfigurationMetadataParser.getItemHintsNew(rootObject);
        for (JsonElement element : properties) {
            SpringBootApplicationMetaConfigKeyImpl key;
            SpringBootApplicationMetaConfigKey.ItemHint keyHint;
            SpringBootApplicationMetaConfigKey.ItemHint valueHint;
            JsonObject property = element.getAsJsonObject();
            String configKeyName = SpringBootConfigurationMetadataParser.getStringLiteral(property, "name");
            if (StringUtil.isEmptyOrSpaces((String)configKeyName)) continue;
            String typeLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(property, "type");
            PsiType type = typeLiteral != null ? this.myCachedTypes.get(typeLiteral) : null;
            SpringBootApplicationMetaConfigKey.AccessType accessType = this.getAccessType(type);
            if (accessType == SpringBootApplicationMetaConfigKey.AccessType.MAP) {
                valueHint = hints.get(configKeyName + ".values");
                keyHint = hints.get(configKeyName + ".keys");
            } else {
                valueHint = hints.get(configKeyName);
                keyHint = SpringBootApplicationMetaConfigKey.ItemHint.NONE;
            }
            if (processor.process((Object)(key = new SpringBootApplicationMetaConfigKeyImpl(this.getDeclaration(property, configKeyName, type), configKeyName, SpringBootConfigurationMetadataParser.getDescription(property), SpringBootConfigurationMetadataParser.getValueAsString(property, "defaultValue"), SpringBootConfigurationMetadataParser.getDeprecation(property), type, accessType, (SpringBootApplicationMetaConfigKey.ItemHint)ObjectUtils.notNull((Object)valueHint, (Object)SpringBootApplicationMetaConfigKey.ItemHint.NONE), (SpringBootApplicationMetaConfigKey.ItemHint)ObjectUtils.notNull((Object)keyHint, (Object)SpringBootApplicationMetaConfigKey.ItemHint.NONE))))) continue;
            return false;
        }
        return true;
    }

    private SpringBootApplicationMetaConfigKey.AccessType getAccessType(@Nullable PsiType type) {
        if (type == null) {
            return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
        }
        return this.myCachedAccessType.get(type);
    }

    @Nullable
    private static String getValueAsString(JsonObject object, String propertyName) {
        JsonElement defaultValueProperty = object.get(propertyName);
        if (defaultValueProperty == null) {
            return null;
        }
        if (defaultValueProperty.isJsonPrimitive()) {
            return defaultValueProperty.getAsJsonPrimitive().getAsString();
        }
        if (!defaultValueProperty.isJsonArray()) {
            return null;
        }
        com.google.gson.JsonArray array = defaultValueProperty.getAsJsonArray();
        SmartList valueList = new SmartList();
        for (JsonElement jsonValue : array) {
            if (!jsonValue.isJsonPrimitive()) continue;
            valueList.add(StringUtil.wrapWithDoubleQuote((String)jsonValue.getAsJsonPrimitive().getAsString()));
        }
        return "[" + StringUtil.join((Collection)valueList, (String)", ") + "]";
    }

    @NotNull
    private PsiElement getDeclaration(JsonObject entry, String configKeyName, PsiType type) {
        String sourceTypeText = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "sourceType");
        if (StringUtil.isEmpty((String)sourceTypeText)) {
            ConfigKeyDeclarationPsiElement configKeyDeclarationPsiElement = new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)this.myJsonFile, this.getAdditionalTarget(configKeyName), configKeyName, configKeyName, type);
            if (configKeyDeclarationPsiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getDeclaration"));
            }
            return configKeyDeclarationPsiElement;
        }
        PsiClass sourceTypeClass = this.myCachedClass.get(sourceTypeText);
        if (sourceTypeClass == null) {
            ConfigKeyDeclarationPsiElement configKeyDeclarationPsiElement = new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)this.myJsonFile, this.getAdditionalTarget(configKeyName), configKeyName, sourceTypeText, type);
            if (configKeyDeclarationPsiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getDeclaration"));
            }
            return configKeyDeclarationPsiElement;
        }
        ConfigKeyDeclarationPsiElement configKeyDeclarationPsiElement = new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)sourceTypeClass, SpringBootConfigurationMetadataParser.getNavigationTarget(sourceTypeClass, configKeyName), configKeyName, sourceTypeText, type);
        if (configKeyDeclarationPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getDeclaration"));
        }
        return configKeyDeclarationPsiElement;
    }

    @NotNull
    private PsiElement getAdditionalTarget(String configKeyName) {
        PsiElement additionalTarget = (PsiElement)((Map)this.myAdditionalConfigTargets.getValue()).get(configKeyName);
        Object object = additionalTarget != null ? additionalTarget : this.myJsonFile;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getAdditionalTarget"));
        }
        return object;
    }

    @NotNull
    private static PsiElement getNavigationTarget(@NotNull PsiClass sourceTypeClass, String configKeyName) {
        if (sourceTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTypeClass", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getNavigationTarget"));
        }
        String propertyName = SpringBootConfigurationMetadataParser.configKeyAsPropertyName(configKeyName);
        PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
        if (setter != null) {
            PsiMethod psiMethod = setter;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getNavigationTarget"));
            }
            return psiMethod;
        }
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
        Object object = getter != null ? getter : sourceTypeClass;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getNavigationTarget"));
        }
        return object;
    }

    private static SpringBootApplicationMetaConfigKey.DescriptionText getDescription(JsonObject property) {
        String descriptionText = SpringBootConfigurationMetadataParser.getStringLiteral(property, "description");
        return new SpringBootApplicationMetaConfigKey.DescriptionText(StringUtil.notNullize((String)descriptionText));
    }

    private static SpringBootApplicationMetaConfigKey.Deprecation getDeprecation(JsonObject property) {
        JsonObject deprecationObject = property.getAsJsonObject("deprecation");
        if (deprecationObject != null) {
            String reasonLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "reason");
            SpringBootApplicationMetaConfigKey.DescriptionText reason = new SpringBootApplicationMetaConfigKey.DescriptionText(StringUtil.notNullize((String)reasonLiteral));
            String replacement = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "replacement");
            return new SpringBootApplicationMetaConfigKey.Deprecation(reason, replacement);
        }
        JsonPrimitive deprecatedProperty = property.getAsJsonPrimitive("deprecated");
        if (deprecatedProperty != null && deprecatedProperty.getAsBoolean()) {
            return new SpringBootApplicationMetaConfigKey.Deprecation(new SpringBootApplicationMetaConfigKey.DescriptionText(""), null);
        }
        return SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED;
    }

    private static Map<String, SpringBootApplicationMetaConfigKey.ItemHint> getItemHintsNew(JsonObject rootObject) {
        JsonElement hintsElement = rootObject.get("hints");
        if (hintsElement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SpringBootApplicationMetaConfigKey.ItemHint> itemHintsMap = new HashMap<String, SpringBootApplicationMetaConfigKey.ItemHint>();
        for (JsonElement value : hintsElement.getAsJsonArray()) {
            JsonObject entry = value.getAsJsonObject();
            String nameValue = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "name");
            if (nameValue == null) continue;
            itemHintsMap.put(nameValue, SpringBootConfigurationMetadataParser.createItemHint(entry));
        }
        return itemHintsMap;
    }

    private static SpringBootApplicationMetaConfigKey.ItemHint createItemHint(JsonObject entry) {
        List<SpringBootApplicationMetaConfigKey.ValueProvider> providers = SpringBootConfigurationMetadataParser.getItemHintProviders(entry);
        List<SpringBootApplicationMetaConfigKey.ValueHint> values = SpringBootConfigurationMetadataParser.getItemHintValues(entry);
        return new SpringBootApplicationMetaConfigKey.ItemHint(providers, values);
    }

    private static List<SpringBootApplicationMetaConfigKey.ValueProvider> getItemHintProviders(JsonObject entry) {
        JsonElement providersObject = entry.get("providers");
        if (providersObject == null) {
            return Collections.emptyList();
        }
        List providers = ContainerUtil.newSmartList();
        for (JsonElement arrayValue : providersObject.getAsJsonArray()) {
            JsonObject providerObject;
            String name;
            if (!arrayValue.isJsonObject() || (name = SpringBootConfigurationMetadataParser.getStringLiteral(providerObject = arrayValue.getAsJsonObject(), "name")) == null) continue;
            Map<String, String> parameters = SpringBootConfigurationMetadataParser.getItemHintProviderParameters(providerObject);
            providers.add(new SpringBootApplicationMetaConfigKey.ValueProvider(name, parameters));
        }
        return providers;
    }

    private static Map<String, String> getItemHintProviderParameters(JsonObject entry) {
        JsonElement parametersProperty = entry.get("parameters");
        if (parametersProperty == null || !parametersProperty.isJsonObject()) {
            return Collections.emptyMap();
        }
        JsonObject parametersObject = parametersProperty.getAsJsonObject();
        LinkedHashMap parameters = ContainerUtil.newLinkedHashMap();
        for (Map.Entry parameterProperty : parametersObject.entrySet()) {
            JsonElement value = (JsonElement)parameterProperty.getValue();
            if (value == null || !value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            parameters.put(parameterProperty.getKey(), primitive.getAsString());
        }
        return parameters;
    }

    private static List<SpringBootApplicationMetaConfigKey.ValueHint> getItemHintValues(JsonObject entry) {
        JsonElement valuesObject = entry.get("values");
        if (valuesObject == null || !valuesObject.isJsonArray()) {
            return Collections.emptyList();
        }
        List values = ContainerUtil.newSmartList();
        for (JsonElement arrayValue : valuesObject.getAsJsonArray()) {
            JsonObject valueObject;
            String value;
            if (!arrayValue.isJsonObject() || (value = SpringBootConfigurationMetadataParser.getStringLiteral(valueObject = arrayValue.getAsJsonObject(), "value")) == null) continue;
            values.add(new SpringBootApplicationMetaConfigKey.ValueHint(value, SpringBootConfigurationMetadataParser.getDescription(valueObject)));
        }
        return values;
    }

    @Nullable
    private static String getStringLiteral(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        return property != null ? property.getAsString() : null;
    }

    private static String configKeyAsPropertyName(String configKey) {
        String propertyKey = configKey.substring(configKey.lastIndexOf(46) + 1);
        if (!StringUtil.containsChar((String)propertyKey, (char)'-')) {
            return propertyKey;
        }
        StringBuilder buf = new StringBuilder();
        String[] tokens = propertyKey.split("-");
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            String token = tokens[i];
            if (token == null || token.length() == 0) continue;
            String firstChar = i == 0 ? token.substring(0, 1) : token.substring(0, 1).toUpperCase(Locale.US);
            buf.append(firstChar).append(token.substring(1));
        }
        return buf.toString();
    }
}

